/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.authn;

import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import pl.edu.icm.unity.engine.api.authn.AuthenticationFlow;
import pl.edu.icm.unity.engine.api.authn.LoginSession;
import pl.edu.icm.unity.exceptions.InternalException;
import pl.edu.icm.unity.types.authn.AuthenticationRealm;
import pl.edu.icm.unity.types.basic.IdentityTaV;

public class InvocationContext
implements Serializable {
    private static ThreadLocal<InvocationContext> threadLocal = new ThreadLocal();
    private LoginSession loginSession;
    private Locale locale;
    private IdentityTaV tlsIdentity;
    private AuthenticationRealm realm;
    private String currentURLUsed;
    private List<AuthenticationFlow> endpointFlows;

    public InvocationContext(IdentityTaV tlsIdentity, AuthenticationRealm realm, List<AuthenticationFlow> endpointFlows) {
        this.endpointFlows = endpointFlows;
        this.setTlsIdentity(tlsIdentity);
        this.realm = realm;
    }

    public static void setCurrent(InvocationContext context) {
        threadLocal.set(context);
    }

    public static InvocationContext getCurrent() throws InternalException {
        InvocationContext ret = threadLocal.get();
        if (ret == null) {
            throw new InternalException("The current call has no invocation context set");
        }
        return ret;
    }

    public static boolean hasCurrent() {
        return threadLocal.get() != null;
    }

    public static String safeGetRealm() {
        try {
            InvocationContext context = InvocationContext.getCurrent();
            AuthenticationRealm realm = context.getRealm();
            return realm != null ? realm.getName() : null;
        }
        catch (InternalException internalException) {
            return null;
        }
    }

    public AuthenticationRealm getRealm() {
        return this.realm;
    }

    public LoginSession getLoginSession() {
        return this.loginSession;
    }

    public void setLoginSession(LoginSession loginSession) {
        this.loginSession = loginSession;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public IdentityTaV getTlsIdentity() {
        return this.tlsIdentity;
    }

    public void setTlsIdentity(IdentityTaV tlsIdentity) {
        this.tlsIdentity = tlsIdentity;
    }

    public List<AuthenticationFlow> getEndpointFlows() {
        return this.endpointFlows;
    }

    public String getCurrentURLUsed() {
        return this.currentURLUsed;
    }

    public void setCurrentURLUsed(String currentURLUsed) {
        this.currentURLUsed = currentURLUsed;
    }
}

