/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.authn;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.Date;
import pl.edu.icm.unity.Constants;
import pl.edu.icm.unity.types.authn.AuthenticationOptionKey;
import pl.edu.icm.unity.types.authn.RememberMePolicy;

public class RememberMeToken {
    private long entity;
    private LoginMachineDetails machineDetails;
    private Date loginTime;
    private AuthenticationOptionKey firstFactorAuthnOptionId;
    private AuthenticationOptionKey secondFactorAuthnOptionId;
    private byte[] rememberMeTokenHash;
    private RememberMePolicy rememberMePolicy;

    public RememberMeToken() {
    }

    public RememberMeToken(long entity, LoginMachineDetails machineDetails, Date loginTime, AuthenticationOptionKey firstFactorAuthnOptionId, AuthenticationOptionKey secondFactorAuthnOptionId, byte[] rememberMeTokenHash, RememberMePolicy rememberMePolicy) {
        this.entity = entity;
        this.machineDetails = machineDetails;
        this.loginTime = loginTime;
        this.firstFactorAuthnOptionId = firstFactorAuthnOptionId;
        this.secondFactorAuthnOptionId = secondFactorAuthnOptionId;
        this.rememberMeTokenHash = rememberMeTokenHash;
        this.rememberMePolicy = rememberMePolicy;
    }

    public static RememberMeToken getInstanceFromJson(byte[] json) {
        try {
            return (RememberMeToken)Constants.MAPPER.readValue(json, RememberMeToken.class);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Can not parse token's JSON", e);
        }
    }

    @JsonIgnore
    public byte[] getSerialized() throws JsonProcessingException {
        return Constants.MAPPER.writeValueAsBytes((Object)this);
    }

    public long getEntity() {
        return this.entity;
    }

    public void setEntity(long entity) {
        this.entity = entity;
    }

    public LoginMachineDetails getMachineDetails() {
        return this.machineDetails;
    }

    public void setMachineDetails(LoginMachineDetails machineDetails) {
        this.machineDetails = machineDetails;
    }

    public Date getLoginTime() {
        return this.loginTime;
    }

    public void setLoginTime(Date loginTime) {
        this.loginTime = loginTime;
    }

    public byte[] getRememberMeTokenHash() {
        return this.rememberMeTokenHash;
    }

    public void setRememberMeTokenHash(byte[] rememberMeTokenHash) {
        this.rememberMeTokenHash = rememberMeTokenHash;
    }

    public RememberMePolicy getRememberMePolicy() {
        return this.rememberMePolicy;
    }

    public void setRememberMePolicy(RememberMePolicy rememberMePolicy) {
        this.rememberMePolicy = rememberMePolicy;
    }

    public AuthenticationOptionKey getFirstFactorAuthnOptionId() {
        return this.firstFactorAuthnOptionId;
    }

    public void setFirstFactorAuthnOptionId(AuthenticationOptionKey firstFactorAuthnOptionId) {
        this.firstFactorAuthnOptionId = firstFactorAuthnOptionId;
    }

    public AuthenticationOptionKey getSecondFactorAuthnOptionId() {
        return this.secondFactorAuthnOptionId;
    }

    public void setSecondFactorAuthnOptionId(AuthenticationOptionKey secondFactorAuthnOptionId) {
        this.secondFactorAuthnOptionId = secondFactorAuthnOptionId;
    }

    public static class LoginMachineDetails {
        private String ip;
        private String os;
        private String browser;

        public LoginMachineDetails() {
        }

        public LoginMachineDetails(String ip, String os, String browser) {
            this.setIp(ip);
            this.os = os;
            this.setBrowser(browser);
        }

        public String getIp() {
            return this.ip;
        }

        public void setIp(String ip) {
            this.ip = ip;
        }

        public String getOs() {
            return this.os;
        }

        public void setOs(String os) {
            this.os = os;
        }

        public String getBrowser() {
            return this.browser;
        }

        public void setBrowser(String browser) {
            this.browser = browser;
        }
    }
}

