/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.config;

import eu.unicore.security.canl.CredentialProperties;
import eu.unicore.security.canl.TruststoreProperties;
import eu.unicore.util.configuration.DocumentationReferenceMeta;
import eu.unicore.util.configuration.DocumentationReferencePrefix;
import eu.unicore.util.configuration.PropertiesHelper;
import eu.unicore.util.configuration.PropertyMD;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.Logger;
import pl.edu.icm.unity.base.utils.Log;

public class UnityPKIConfiguration
extends PropertiesHelper {
    private static final Logger log = Log.getLogger((String)"unity.server.config", UnityPKIConfiguration.class);
    @DocumentationReferencePrefix
    public static final String P = "unity.pki.";
    public static final String CREDENTIALS = "credentials.";
    public static final String TRUSTSTORES = "truststores.";
    public static final String CERTIFICATES = "certificates.";
    public static final String CERTIFICATE_FILE = "certificateFile";
    @DocumentationReferenceMeta
    public static final Map<String, PropertyMD> defaults = new HashMap<String, PropertyMD>();

    public UnityPKIConfiguration(Properties source) {
        super(P, source, defaults, log);
    }

    public String getCredentialPrefix(String credential) {
        return P + credential;
    }

    public String getCredentialName(String listKey) {
        return listKey.substring(CREDENTIALS.length(), listKey.length() - 1);
    }

    public String getTruststorePrefix(String truststore) {
        return P + truststore;
    }

    public String getTruststoreName(String listKey) {
        return listKey.substring(TRUSTSTORES.length(), listKey.length() - 1);
    }

    public String getCertificateName(String listKey) {
        return listKey.substring(CERTIFICATES.length(), listKey.length() - 1);
    }

    public Properties getProperties() {
        return this.properties;
    }

    static {
        defaults.put(CREDENTIALS, new PropertyMD().setStructuredList(false).setDescription("List of credentials. The subkey defines the credential name."));
        for (Map.Entry e : CredentialProperties.META.entrySet()) {
            defaults.put((String)e.getKey(), ((PropertyMD)e.getValue()).setStructuredListEntry(CREDENTIALS).setHidden());
        }
        defaults.put(TRUSTSTORES, new PropertyMD().setStructuredList(false).setDescription("List of truststores. The subkey defines the truststore name."));
        for (Map.Entry e : TruststoreProperties.META.entrySet()) {
            defaults.put((String)e.getKey(), ((PropertyMD)e.getValue()).setStructuredListEntry(TRUSTSTORES).setHidden());
        }
        defaults.put(CERTIFICATES, new PropertyMD().setStructuredList(false).setDescription("List of certificates."));
        defaults.put(CERTIFICATE_FILE, new PropertyMD().setStructuredListEntry(CERTIFICATES).setMandatory().setDescription("Certificate file path (PEM format)."));
    }
}

