/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.idp;

import com.google.common.collect.Lists;
import eu.unicore.util.configuration.PropertiesHelper;
import eu.unicore.util.configuration.PropertyMD;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import pl.edu.icm.unity.MessageSource;
import pl.edu.icm.unity.engine.api.config.UnityPropertiesHelper;
import pl.edu.icm.unity.engine.api.idp.IdpPolicyAgreementsConfiguration;
import pl.edu.icm.unity.engine.api.idp.IdpPolicyAgreementsConfigurationParser;
import pl.edu.icm.unity.engine.api.userimport.UserImportSpec;
import pl.edu.icm.unity.types.basic.DynamicAttribute;

public class CommonIdPProperties {
    public static final String SKIP_CONSENT = "skipConsent";
    public static final String TRANSLATION_PROFILE = "translationProfile";
    public static final String EMBEDDED_TRANSLATION_PROFILE = "embeddedTranslationProfile";
    public static final String SKIP_USERIMPORT = "skipUserImport";
    public static final String USERIMPORT_PFX = "userImport.";
    public static final String USERIMPORT_IMPORTER = "importer";
    public static final String USERIMPORT_IDENTITY_TYPE = "identityType";
    public static final String ACTIVE_VALUE_SELECTION_PFX = "activeValue.";
    public static final String ACTIVE_VALUE_CLIENT = "client";
    public static final String ACTIVE_VALUE_SINGLE_SELECTABLE = "singleValueAttributes.";
    public static final String ACTIVE_VALUE_MULTI_SELECTABLE = "multiValueAttributes.";
    private static final String ASSUME_FORCE = "assumeForceOnSessionClash";
    public static final String POLICY_AGREEMENTS_TITLE = "policyAgreementsTitle";
    public static final String POLICY_AGREEMENTS_INFO = "policyAgreementsInfo";
    public static final String POLICY_AGREEMENTS_WIDTH = "policyAgreementsWidth";
    public static final String POLICY_AGREEMENTS_WIDTH_UNIT = "policyAgreementsWidthUnit";
    public static final String POLICY_AGREEMENTS_PFX = "policyAgreements.";
    public static final String POLICY_AGREEMENT_DOCUMENTS = "policyDocuments";
    public static final String POLICY_AGREEMENT_PRESENTATION_TYPE = "policyAgreementPresentationType";
    public static final String POLICY_AGREEMENT_TEXT = "text";

    public static Map<String, PropertyMD> getDefaultsWithCategory(PropertyMD.DocumentationCategory category, String defaultProfileMessage, String defaultProfile) {
        Map<String, PropertyMD> defaults = CommonIdPProperties.getDefaults(defaultProfileMessage, defaultProfile);
        for (PropertyMD md : defaults.values()) {
            md.setCategory(category);
        }
        return defaults;
    }

    public static Map<String, PropertyMD> getDefaults(String defaultProfileMessage, String defaultProfile) {
        HashMap<String, PropertyMD> defaults = new HashMap<String, PropertyMD>();
        defaults.put(SKIP_CONSENT, new PropertyMD("false").setDescription("Controls whether the user being authenticated should see the consent screen with the information what service requested authorization and what data is going to be released. Note that user may always choose to disable the consent screen for each service, even if this setting is set to false."));
        defaults.put(TRANSLATION_PROFILE, defaultProfile != null ? new PropertyMD(defaultProfile).setDescription(defaultProfileMessage) : new PropertyMD().setDescription(defaultProfileMessage));
        defaults.put(EMBEDDED_TRANSLATION_PROFILE, new PropertyMD().setHidden().setDescription(defaultProfileMessage));
        defaults.put(ASSUME_FORCE, new PropertyMD("true").setDeprecated().setDescription("Ignored since 2.5.0, please remove the option from configuration"));
        defaults.put(USERIMPORT_PFX, new PropertyMD().setStructuredList(false).setDescription("Under this prefix it is possible to configure enabled user importers on this endpoint. If no such options are defined then the user import feature is disabled, except of SAML SOAP assertion query endpoint on which by default all system defined user importers are enabled (this is for backwards compatibility reasons and can be disabled with skip option)."));
        defaults.put(USERIMPORT_IMPORTER, new PropertyMD().setStructuredListEntry(USERIMPORT_PFX).setDescription("Defines which user import configuration should be triggered."));
        defaults.put(USERIMPORT_IDENTITY_TYPE, new PropertyMD().setStructuredListEntry(USERIMPORT_PFX).setDescription("Authenticated user's identity of this type will be used as user importer parameter. If user has more then one identity of this type then a random one is used."));
        defaults.put(SKIP_USERIMPORT, new PropertyMD("false").setDescription("Allows to completely disable user import functionality per endpoint. Useful mostly on SAML SOAP endpoint, where default is to useall (and not only defined with userImport.) importers. "));
        defaults.put(ACTIVE_VALUE_SELECTION_PFX, new PropertyMD().setStructuredList(false).setDescription("Under this prefix it is possible to configure a separate screen on which user can select attribute values which are used for the session. Multiple entries can be added with settings which are clients specific."));
        defaults.put(ACTIVE_VALUE_CLIENT, new PropertyMD().setStructuredListEntry(ACTIVE_VALUE_SELECTION_PFX).setDescription("Identifier of a client for which the settings should be applied. If unset then those settings will be default. If more then one entry without client set is present, or there is more then one with the same client, then it is undefined which one will be used."));
        defaults.put(ACTIVE_VALUE_SINGLE_SELECTABLE, new PropertyMD().setStructuredListEntry(ACTIVE_VALUE_SELECTION_PFX).setList(false).setDescription("List of attribute names for which a single active value must be selected by a user."));
        defaults.put(ACTIVE_VALUE_MULTI_SELECTABLE, new PropertyMD().setStructuredListEntry(ACTIVE_VALUE_SELECTION_PFX).setList(false).setDescription("List of attribute names for which multiple active values must be selected by a user."));
        defaults.put(POLICY_AGREEMENTS_TITLE, new PropertyMD().setCanHaveSubkeys().setDescription("Policy acceptanance view title"));
        defaults.put(POLICY_AGREEMENTS_INFO, new PropertyMD().setCanHaveSubkeys().setDescription("Policy acceptanance view additional information"));
        defaults.put(POLICY_AGREEMENTS_WIDTH, new PropertyMD("40").setDescription("Policy acceptanance view widht"));
        defaults.put(POLICY_AGREEMENTS_WIDTH_UNIT, new PropertyMD("em").setDescription("Policy acceptanance view width unit"));
        defaults.put(POLICY_AGREEMENTS_INFO, new PropertyMD().setCanHaveSubkeys().setDescription("Policy acceptanance view additional information"));
        defaults.put(POLICY_AGREEMENTS_PFX, new PropertyMD().setStructuredList(true).setDescription("Individual policy agreement items are configured under this prefix"));
        defaults.put(POLICY_AGREEMENT_DOCUMENTS, new PropertyMD().setStructuredListEntry(POLICY_AGREEMENTS_PFX).setDescription("List of policy documents ids included in the item"));
        defaults.put(POLICY_AGREEMENT_PRESENTATION_TYPE, new PropertyMD().setStructuredListEntry(POLICY_AGREEMENTS_PFX).setDescription("Policy agreement presentation type"));
        defaults.put(POLICY_AGREEMENT_TEXT, new PropertyMD().setCanHaveSubkeys().setStructuredListEntry(POLICY_AGREEMENTS_PFX).setDescription("Policy agreement text with placeholders. Format of placeholder is {PolicyDocucmentId:DisplayedText}"));
        return defaults;
    }

    public static List<UserImportSpec> getUserImportsLegacy(PropertiesHelper cfg, String identity, String type) {
        Set structuredListKeys = cfg.getStructuredListKeys(USERIMPORT_PFX);
        Boolean skip = cfg.getBooleanValue(SKIP_USERIMPORT);
        if (structuredListKeys.isEmpty()) {
            return skip != false ? Collections.emptyList() : Lists.newArrayList((Object[])new UserImportSpec[]{UserImportSpec.withAllImporters(identity, type)});
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(type, identity);
        return CommonIdPProperties.getUserImports(cfg, map);
    }

    public static List<UserImportSpec> getUserImports(PropertiesHelper cfg, Map<String, String> identitiesByType) {
        Set structuredListKeys = cfg.getStructuredListKeys(USERIMPORT_PFX);
        if (structuredListKeys.isEmpty() || cfg.getBooleanValue(SKIP_USERIMPORT).booleanValue()) {
            return Collections.emptyList();
        }
        ArrayList<UserImportSpec> ret = new ArrayList<UserImportSpec>();
        for (String key : structuredListKeys) {
            String importer = cfg.getValue(key + USERIMPORT_IMPORTER);
            String type = cfg.getValue(key + USERIMPORT_IDENTITY_TYPE);
            String identityValue = identitiesByType.get(type);
            if (identityValue == null) continue;
            ret.add(new UserImportSpec(importer, identityValue, type));
        }
        return ret;
    }

    public static Optional<ActiveValueSelectionConfig> getActiveValueSelectionConfig(PropertiesHelper cfg, String client, Collection<DynamicAttribute> allAttributes) {
        Optional<String> key = CommonIdPProperties.getActiveValueSelectionConfigKey(cfg, client);
        return key.isPresent() ? CommonIdPProperties.getActiveValueSelectionConfigFromKey(cfg, key.get(), allAttributes) : Optional.empty();
    }

    public static boolean isActiveValueSelectionConfiguredForClient(PropertiesHelper cfg, String client) {
        return CommonIdPProperties.getActiveValueSelectionConfigKey(cfg, client).isPresent();
    }

    private static Optional<String> getActiveValueSelectionConfigKey(PropertiesHelper cfg, String client) {
        Set listKeys = cfg.getStructuredListKeys(ACTIVE_VALUE_SELECTION_PFX);
        String defaultClientKey = null;
        for (String key : listKeys) {
            String entryClient = cfg.getValue(key + ACTIVE_VALUE_CLIENT);
            if (entryClient == null) {
                defaultClientKey = key;
                continue;
            }
            if (!entryClient.equals(client)) continue;
            return Optional.of(key);
        }
        return Optional.ofNullable(defaultClientKey);
    }

    private static Optional<ActiveValueSelectionConfig> getActiveValueSelectionConfigFromKey(PropertiesHelper cfg, String key, Collection<DynamicAttribute> attributes) {
        Map<String, DynamicAttribute> attrsMap = attributes.stream().collect(Collectors.toMap(da -> da.getAttribute().getName(), da -> da));
        List<DynamicAttribute> singleSelectable = CommonIdPProperties.getAttributeForSelection(cfg, attrsMap, key + ACTIVE_VALUE_SINGLE_SELECTABLE);
        List<DynamicAttribute> multiSelectable = CommonIdPProperties.getAttributeForSelection(cfg, attrsMap, key + ACTIVE_VALUE_MULTI_SELECTABLE);
        if (singleSelectable.isEmpty() && multiSelectable.isEmpty()) {
            return Optional.empty();
        }
        ArrayList<DynamicAttribute> remaining = new ArrayList<DynamicAttribute>(attributes);
        remaining.removeAll(singleSelectable);
        remaining.removeAll(multiSelectable);
        return Optional.of(new ActiveValueSelectionConfig(multiSelectable, singleSelectable, remaining));
    }

    private static List<DynamicAttribute> getAttributeForSelection(PropertiesHelper cfg, Map<String, DynamicAttribute> attributes, String key) {
        List names = cfg.getListOfValues(key);
        return names.stream().map(attr -> (DynamicAttribute)attributes.get(attr)).filter(attr -> attr != null).collect(Collectors.toList());
    }

    public static IdpPolicyAgreementsConfiguration getPolicyAgreementsConfig(MessageSource msg, UnityPropertiesHelper cfg) {
        return IdpPolicyAgreementsConfigurationParser.fromPropoerties(msg, cfg);
    }

    public static boolean isIdpPolicyAgreementsConfigured(MessageSource msg, UnityPropertiesHelper cfg) {
        return !CommonIdPProperties.getPolicyAgreementsConfig((MessageSource)msg, (UnityPropertiesHelper)cfg).agreements.isEmpty();
    }

    public static class ActiveValueSelectionConfig {
        public final List<DynamicAttribute> multiSelectableAttributes;
        public final List<DynamicAttribute> singleSelectableAttributes;
        public final List<DynamicAttribute> remainingAttributes;

        public ActiveValueSelectionConfig(List<DynamicAttribute> multiSelectableAttributes, List<DynamicAttribute> singleSelectableAttributes, List<DynamicAttribute> remainingAttributes) {
            this.multiSelectableAttributes = multiSelectableAttributes;
            this.singleSelectableAttributes = singleSelectableAttributes;
            this.remainingAttributes = remainingAttributes;
        }
    }
}

