/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.registration;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import pl.edu.icm.unity.engine.api.registration.GroupPatternMatcher;
import pl.edu.icm.unity.engine.api.registration.RequestedGroupDiff;
import pl.edu.icm.unity.types.basic.Group;
import pl.edu.icm.unity.types.registration.GroupRegistrationParam;
import pl.edu.icm.unity.types.registration.GroupSelection;

public class GroupDiffUtils {
    public static RequestedGroupDiff getSingleGroupDiff(List<Group> allGroups, List<Group> allUserGroups, GroupSelection selected, GroupRegistrationParam formGroup) {
        List<Group> usersGroup = GroupPatternMatcher.filterByIncludeGroupsMode(GroupPatternMatcher.filterMatching(allUserGroups, formGroup.getGroupPath()), formGroup.getIncludeGroupsMode());
        List selectedGroups = GroupPatternMatcher.filterByIncludeGroupsMode(GroupPatternMatcher.filterMatching(allGroups, selected.getSelectedGroups()), formGroup.getIncludeGroupsMode()).stream().map(g -> g.toString()).collect(Collectors.toList());
        HashSet<String> toAdd = new HashSet<String>();
        HashSet<String> toRemove = new HashSet<String>();
        HashSet<String> remain = new HashSet<String>();
        remain.addAll(usersGroup.stream().map(g -> g.toString()).collect(Collectors.toSet()));
        remain.retainAll(selectedGroups);
        remain.addAll(usersGroup.stream().filter(g -> g.isTopLevel()).map(g -> g.toString()).collect(Collectors.toSet()));
        toRemove.addAll(usersGroup.stream().filter(g -> !g.isTopLevel()).map(g -> g.toString()).collect(Collectors.toSet()));
        toRemove.removeAll(remain);
        toAdd.addAll(selectedGroups);
        toAdd.removeAll(remain);
        return new RequestedGroupDiff(toAdd, GroupDiffUtils.filterGroupsForAddFromGroupsToRemove(toAdd, toRemove), remain);
    }

    public static RequestedGroupDiff getAllRequestedGroupsDiff(List<Group> allGroups, List<Group> allUserGroup, List<GroupSelection> groupSelections, List<GroupRegistrationParam> formGroupParams) {
        ArrayList<RequestedGroupDiff> diffs = new ArrayList<RequestedGroupDiff>();
        for (int i = 0; i < formGroupParams.size(); ++i) {
            if (groupSelections.get(i) == null) continue;
            diffs.add(GroupDiffUtils.getSingleGroupDiff(allGroups, allUserGroup, groupSelections.get(i), formGroupParams.get(i)));
        }
        HashSet<String> allAdd = new HashSet<String>();
        HashSet<String> allRemain = new HashSet<String>();
        HashSet<String> allRemove = new HashSet<String>();
        for (RequestedGroupDiff diff : diffs) {
            allAdd.addAll(diff.toAdd);
            allRemain.addAll(diff.remain);
            allRemove.addAll(diff.toRemove);
        }
        allAdd.removeAll(allRemain);
        allRemove.removeAll(allRemain);
        return new RequestedGroupDiff(allAdd, GroupDiffUtils.filterGroupsForAddFromGroupsToRemove(allAdd, allRemove), allRemain);
    }

    private static Set<String> filterGroupsForAddFromGroupsToRemove(Set<String> toAdd, Set<String> toRemove) {
        HashSet<String> toRemoveFiltered = new HashSet<String>();
        for (String rgroup : toRemove) {
            if (GroupDiffUtils.isParent(rgroup, toAdd)) continue;
            toRemoveFiltered.add(rgroup);
        }
        return toRemoveFiltered;
    }

    private static boolean isParent(String group, Set<String> potentialChild) {
        for (String cgroup : potentialChild) {
            if (!Group.isChildOrSame((String)cgroup, (String)group)) continue;
            return true;
        }
        return false;
    }
}

