/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.registration;

import java.util.List;
import org.apache.logging.log4j.util.Strings;
import pl.edu.icm.unity.MessageSource;
import pl.edu.icm.unity.engine.api.finalization.WorkflowFinalizationConfiguration;
import pl.edu.icm.unity.engine.api.registration.RegistrationRedirectURLBuilder;
import pl.edu.icm.unity.types.I18nString;
import pl.edu.icm.unity.types.registration.RegistrationRequestStatus;
import pl.edu.icm.unity.types.registration.RegistrationWrapUpConfig;

public class PostFillingHandler {
    private MessageSource msg;
    private String formId;
    private List<RegistrationWrapUpConfig> wrapUpConfigs;
    private String pageTitle;
    private String logoURL;
    private String msgPrefix;

    public PostFillingHandler(String formId, List<RegistrationWrapUpConfig> wrapUpConfigs, MessageSource msg, String pageTitle, String logoURL, boolean registration) {
        this.formId = formId;
        this.wrapUpConfigs = wrapUpConfigs;
        this.msg = msg;
        this.pageTitle = pageTitle;
        this.logoURL = logoURL;
        this.msgPrefix = registration ? "RegistrationWrupUp." : "EnquiryWrupUp.";
    }

    public WorkflowFinalizationConfiguration getFinalRegistrationConfigurationPostSubmit(String requestId, RegistrationRequestStatus status) {
        RegistrationWrapUpConfig.TriggeringState state = this.requestStatusToState(status);
        boolean success = status != RegistrationRequestStatus.rejected;
        return this.getFinalRegistrationConfigurationGeneric(success, state, requestId);
    }

    public WorkflowFinalizationConfiguration getFinalRegistrationConfigurationNonSubmit(boolean successful, String requestId, RegistrationWrapUpConfig.TriggeringState state) {
        return this.getFinalRegistrationConfigurationGeneric(successful, state, requestId);
    }

    public WorkflowFinalizationConfiguration getFinalRegistrationConfigurationOnError(RegistrationWrapUpConfig.TriggeringState state) {
        return this.getFinalRegistrationConfigurationGeneric(false, state, null);
    }

    private WorkflowFinalizationConfiguration getFinalRegistrationConfigurationGeneric(boolean successful, RegistrationWrapUpConfig.TriggeringState state, String requestId) {
        RegistrationWrapUpConfig config = this.getWrapUpConfigForState(state);
        String title = this.getTitle(state, config);
        String info = this.getInfo(state, config);
        String finalRedirectURL = this.buildFinalRedirectURL(config, requestId, state);
        if (config.isAutomatic() && Strings.isNotEmpty((CharSequence)finalRedirectURL)) {
            return WorkflowFinalizationConfiguration.autoRedirect(finalRedirectURL);
        }
        String redirectCaption = config.getRedirectCaption() == null ? this.msg.getMessage("RegistrationFormsChooserComponent.defaultRedirectCaption", new Object[0]) : config.getRedirectCaption().getValue(this.msg);
        return WorkflowFinalizationConfiguration.builder().setSuccess(successful).setAutoRedirect(false).setRedirectURL(finalRedirectURL).setRedirectButtonText(redirectCaption).setRedirectAfter(config.getRedirectAfterTime()).setMainInformation(title).setExtraInformation(info).setPageTitle(this.pageTitle).setLogoURL(this.logoURL).build();
    }

    private String buildFinalRedirectURL(RegistrationWrapUpConfig config, String requestId, RegistrationWrapUpConfig.TriggeringState state) {
        return Strings.isEmpty((CharSequence)config.getRedirectURL()) ? null : new RegistrationRedirectURLBuilder(config.getRedirectURL(), this.formId, requestId, state).build();
    }

    private RegistrationWrapUpConfig.TriggeringState requestStatusToState(RegistrationRequestStatus status) {
        switch (status) {
            case accepted: {
                return RegistrationWrapUpConfig.TriggeringState.AUTO_ACCEPTED;
            }
            case pending: {
                return RegistrationWrapUpConfig.TriggeringState.SUBMITTED;
            }
            case rejected: {
                return RegistrationWrapUpConfig.TriggeringState.AUTO_REJECTED;
            }
        }
        throw new IllegalStateException("Unknown status: " + status);
    }

    private RegistrationWrapUpConfig getWrapUpConfigForState(RegistrationWrapUpConfig.TriggeringState state) {
        RegistrationWrapUpConfig defaultCofnig = null;
        for (RegistrationWrapUpConfig config : this.wrapUpConfigs) {
            if (config.getState() == state) {
                return config;
            }
            if (config.getState() != RegistrationWrapUpConfig.TriggeringState.DEFAULT) continue;
            defaultCofnig = config;
        }
        return defaultCofnig == null ? new RegistrationWrapUpConfig(state) : defaultCofnig;
    }

    private String getTitle(RegistrationWrapUpConfig.TriggeringState state, RegistrationWrapUpConfig config) {
        return config.getTitle() == null || config.getTitle().isEmpty() ? this.getDefaultTitle(state) : config.getTitle().getValue(this.msg);
    }

    private String getInfo(RegistrationWrapUpConfig.TriggeringState state, RegistrationWrapUpConfig config) {
        return config.getInfo() == null || config.getInfo().isEmpty() ? this.getDefaultInfo(state) : config.getInfo().getValue(this.msg);
    }

    private String getDefaultTitle(RegistrationWrapUpConfig.TriggeringState state) {
        String msgKey;
        switch (state) {
            case AUTO_ACCEPTED: {
                msgKey = "requestAcceptedTitle";
                break;
            }
            case AUTO_REJECTED: {
                msgKey = "requestRejectedTitle";
                break;
            }
            case CANCELLED: {
                msgKey = "registrationCancelledTitle";
                break;
            }
            case GENERAL_ERROR: {
                msgKey = "genericRegistrationErrorTitle";
                break;
            }
            case INVITATION_CONSUMED: {
                msgKey = "invitationAlreadyConsumedTitle";
                break;
            }
            case INVITATION_EXPIRED: {
                msgKey = "invitationExpiredTitle";
                break;
            }
            case INVITATION_MISSING: {
                msgKey = "invitationUnknownTitle";
                break;
            }
            case PRESET_USER_EXISTS: {
                msgKey = "userExistsTitle";
                break;
            }
            case SUBMITTED: {
                msgKey = "requestSubmittedTitle";
                break;
            }
            case EMAIL_CONFIRMATION_FAILED: {
                msgKey = "confirmationFailedTitle";
                break;
            }
            case EMAIL_CONFIRMED: {
                msgKey = "emailConfirmedTitle";
                break;
            }
            case IGNORED_ENQUIRY: {
                msgKey = "ignoredEnquiry";
                break;
            }
            case NOT_APPLICABLE_ENQUIRY: {
                msgKey = "notApplicableEnquiry";
                break;
            }
            default: {
                msgKey = "genericRegistrtionFinishTitle";
            }
        }
        return new I18nString(this.msgPrefix + msgKey, this.msg, new Object[0]).getValue(this.msg);
    }

    private String getDefaultInfo(RegistrationWrapUpConfig.TriggeringState state) {
        return null;
    }

    public boolean hasConfiguredFinalizationFor(RegistrationWrapUpConfig.TriggeringState toCheck) {
        return this.wrapUpConfigs.stream().map(RegistrationWrapUpConfig::getState).anyMatch(state -> state.equals((Object)toCheck));
    }
}

