/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.translation.out;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import pl.edu.icm.unity.types.basic.Attribute;
import pl.edu.icm.unity.types.basic.DynamicAttribute;
import pl.edu.icm.unity.types.basic.IdentityParam;

public class TranslationResult {
    private Collection<DynamicAttribute> attributes = new HashSet<DynamicAttribute>();
    private Collection<IdentityParam> identities = new ArrayList<IdentityParam>();
    private Collection<Attribute> attributesToPersist = new HashSet<Attribute>();
    private Collection<IdentityParam> identitiesToPersist = new ArrayList<IdentityParam>();
    private String redirectURL;

    public Collection<DynamicAttribute> getAttributes() {
        return this.attributes;
    }

    public Collection<IdentityParam> getIdentities() {
        return this.identities;
    }

    public Collection<Attribute> getAttributesToPersist() {
        return this.attributesToPersist;
    }

    public Collection<IdentityParam> getIdentitiesToPersist() {
        return this.identitiesToPersist;
    }

    public String getRedirectURL() {
        return this.redirectURL;
    }

    public void setRedirectURL(String redirectURL) {
        this.redirectURL = redirectURL;
    }

    public boolean removeAttributesByName(String name) {
        boolean res = false;
        HashSet<DynamicAttribute> copy = new HashSet<DynamicAttribute>(this.attributes);
        for (DynamicAttribute existing : copy) {
            if (!existing.getAttribute().getName().equals(name)) continue;
            this.attributes.remove(existing);
            res = true;
        }
        return res;
    }

    public Set<String> removeAttributesByMatch(Pattern attrPattern) {
        HashSet<String> res = new HashSet<String>();
        HashSet<DynamicAttribute> copy = new HashSet<DynamicAttribute>(this.attributes);
        for (DynamicAttribute existing : copy) {
            if (!attrPattern.matcher(existing.getAttribute().getName()).matches()) continue;
            this.attributes.remove(existing);
            res.add(existing.getAttribute().getName());
        }
        return res;
    }

    public boolean removeAttributesToPersistByName(String name) {
        boolean res = false;
        HashSet<Attribute> copy = new HashSet<Attribute>(this.attributesToPersist);
        for (Attribute existing : copy) {
            if (!existing.getName().equals(name)) continue;
            this.attributesToPersist.remove(existing);
            res = true;
        }
        return res;
    }

    public Set<String> removeAttributesToPersistByMatch(Pattern attrPattern) {
        HashSet<String> res = new HashSet<String>();
        HashSet<Attribute> copy = new HashSet<Attribute>(this.attributesToPersist);
        for (Attribute existing : copy) {
            if (!attrPattern.matcher(existing.getName()).matches()) continue;
            this.attributesToPersist.remove(existing);
            res.add(existing.getName());
        }
        return res;
    }

    public boolean removeIdentityByType(String type) {
        return this.remomveIdentityByType(this.identities, type);
    }

    public boolean removeIdentityToPersistByType(String type) {
        return this.remomveIdentityByType(this.identitiesToPersist, type);
    }

    public Set<IdentityParam> removeIdentityToPersistByTypeAndValueMatch(String type, Pattern idValueRegexp) {
        return this.removeIdentityByTypeAndValueMatch(this.identitiesToPersist, type, idValueRegexp);
    }

    public Set<IdentityParam> removeIdentityByTypeAndValueMatch(String type, Pattern idValueRegexp) {
        return this.removeIdentityByTypeAndValueMatch(this.identities, type, idValueRegexp);
    }

    private boolean remomveIdentityByType(Collection<IdentityParam> from, String type) {
        boolean res = false;
        ArrayList<IdentityParam> copy = new ArrayList<IdentityParam>(from);
        for (IdentityParam id : copy) {
            if (!id.getTypeId().equals(type)) continue;
            from.remove(id);
            res = true;
        }
        return res;
    }

    private Set<IdentityParam> removeIdentityByTypeAndValueMatch(Collection<IdentityParam> from, String type, Pattern idValueRegexp) {
        HashSet<IdentityParam> res = new HashSet<IdentityParam>();
        HashSet<IdentityParam> copy = new HashSet<IdentityParam>(from);
        for (IdentityParam i : copy) {
            if (type != null && !i.getTypeId().equals(type) || idValueRegexp != null && !idValueRegexp.matcher(i.getValue()).matches()) continue;
            from.remove(i);
            res.add(i);
        }
        return res;
    }

    public String toString() {
        return "TranslationResult:\nattributes=" + this.attributes + "\nidentities=" + this.identities + "\nattributesToPersist=" + this.attributesToPersist + "\nidentitiesToPersist=" + this.identitiesToPersist + "\nredirectURL=" + this.redirectURL;
    }
}

