/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.utils;

import freemarker.ext.beans.BeansWrapperBuilder;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import pl.edu.icm.unity.base.utils.Log;
import pl.edu.icm.unity.engine.api.config.UnityServerConfiguration;
import pl.edu.icm.unity.engine.api.utils.FreemarkerUtils;

@Component
public class FreemarkerAppHandler {
    private static final Logger log = Log.getLogger((String)"unity.server.web", FreemarkerAppHandler.class);
    private static final String ERROR_TPL = "error-app.ftl";
    private Configuration cfg = new Configuration(Configuration.VERSION_2_3_21);

    @Autowired
    public FreemarkerAppHandler(UnityServerConfiguration serverConfig) {
        String webRoot = serverConfig.getValue("defaultWebContentDirectory");
        this.cfg.setTemplateLoader(FreemarkerUtils.getTemplateLoader(webRoot, "/templates", this.getClass()));
        BeansWrapperBuilder builder = new BeansWrapperBuilder(Configuration.VERSION_2_3_21);
        this.cfg.setObjectWrapper((ObjectWrapper)builder.build());
    }

    public void printAppErrorPage(Writer out, String subsystem, String genericIntro, String error, String cause) throws IOException {
        log.info("Presenting error page with error {}: {}", (Object)error, (Object)cause);
        HashMap<String, String> datamodel = new HashMap<String, String>();
        datamodel.put("subsystem", subsystem);
        datamodel.put("generalInfo", genericIntro);
        datamodel.put("error", error);
        datamodel.put("errorCause", cause);
        FreemarkerUtils.processTemplate(this.cfg, ERROR_TPL, datamodel, out);
    }

    public void printGenericPage(Writer out, String template, Map<String, String> datamodel) throws IOException {
        FreemarkerUtils.processTemplate(this.cfg, template, datamodel, out);
    }
}

