/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.utils;

import com.google.common.collect.Sets;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.StringLayout;
import org.apache.logging.log4j.core.appender.WriterAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;

public class LogRecorder {
    private static final String PATTERN = "%d %x %m%n";
    private StringWriter writer;
    private static AtomicInteger instances = new AtomicInteger(0);
    private Set<String> facilities;
    private String appenderName;

    public LogRecorder(String ... facilities) {
        this.facilities = Sets.newHashSet((Object[])facilities);
    }

    public void startLogRecording() {
        instances.incrementAndGet();
        this.writer = new StringWriter(100000);
        this.addAppender();
    }

    public void stopLogRecording() {
        if (instances.decrementAndGet() == 0) {
            this.removeAppender();
        }
    }

    private void addAppender() {
        LoggerContext context = LoggerContext.getContext((boolean)false);
        Configuration config = context.getConfiguration();
        PatternLayout layout = PatternLayout.newBuilder().withPattern(PATTERN).build();
        this.appenderName = Thread.currentThread().getName() + "-" + UUID.randomUUID();
        WriterAppender appender = WriterAppender.createAppender((StringLayout)layout, null, (Writer)this.writer, (String)this.appenderName, (boolean)false, (boolean)true);
        appender.start();
        this.addAppenderToLoggers((Appender)appender, config);
    }

    private void removeAppender() {
        LoggerContext context = LoggerContext.getContext((boolean)false);
        Configuration config = context.getConfiguration();
        this.removeAppenderFromLoggers(config);
    }

    private void addAppenderToLoggers(Appender appender, Configuration config) {
        for (LoggerConfig loggerConfig : config.getLoggers().values()) {
            if (!this.facilities.contains(loggerConfig.getName())) continue;
            loggerConfig.addAppender(appender, Level.ALL, null);
        }
    }

    private void removeAppenderFromLoggers(Configuration config) {
        for (LoggerConfig loggerConfig : config.getLoggers().values()) {
            if (!this.facilities.contains(loggerConfig.getName())) continue;
            loggerConfig.removeAppender(this.appenderName);
        }
    }

    public StringBuffer getCapturedLogs() {
        return this.writer.getBuffer();
    }
}

