/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.attributes;

import pl.edu.icm.unity.base.attribute.Attribute;
import pl.edu.icm.unity.base.attribute.AttributeType;

public class DynamicAttribute {
    private Attribute attribute;
    private AttributeType attributeType;
    private String displayedName;
    private String description;
    private boolean mandatory;

    public DynamicAttribute(Attribute attribute, String displayedName, String description, boolean mandatory) {
        this.attribute = attribute;
        this.displayedName = displayedName;
        this.description = description;
        this.mandatory = mandatory;
    }

    public DynamicAttribute(Attribute attribute, AttributeType attributeType, String displayedName, String description, boolean mandatory) {
        this(attribute, displayedName, description, mandatory);
        this.attributeType = attributeType;
    }

    public DynamicAttribute(Attribute attribute) {
        this.attribute = attribute;
        this.mandatory = false;
    }

    public DynamicAttribute(Attribute attribute, AttributeType attributeType) {
        this(attribute);
        this.attributeType = attributeType;
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    public void setAttribute(Attribute attribute) {
        this.attribute = attribute;
    }

    public String getDisplayedName() {
        return this.displayedName;
    }

    public void setDisplayedName(String displayedName) {
        this.displayedName = displayedName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDescription(AttributeType t) {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    public AttributeType getAttributeType() {
        return this.attributeType;
    }

    public void setAttributeType(AttributeType attributeType) {
        this.attributeType = attributeType;
    }

    public DynamicAttribute clone() {
        return new DynamicAttribute(this.attribute.clone(), this.attributeType, this.displayedName, this.description, this.mandatory);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.attribute.toString());
        sb.append(" with meta [");
        sb.append(this.displayedName);
        sb.append(", ");
        sb.append(this.description);
        sb.append(", ");
        sb.append(this.mandatory);
        sb.append("]");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DynamicAttribute other = (DynamicAttribute)obj;
        if (this.attribute == null ? other.attribute != null : !this.attribute.equals((Object)other.attribute)) {
            return false;
        }
        if (this.displayedName == null ? other.displayedName != null : !this.displayedName.equals(other.displayedName)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.mandatory != other.mandatory) {
            return false;
        }
        return !(this.attributeType == null ? other.attributeType != null : !this.attributeType.equals((Object)other.attributeType));
    }
}

