/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.authn;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import pl.edu.icm.unity.base.authn.AuthenticationOptionKey;
import pl.edu.icm.unity.engine.api.authn.AuthenticatedEntity;
import pl.edu.icm.unity.engine.api.authn.AuthenticationException;
import pl.edu.icm.unity.engine.api.authn.AuthenticationFlow;
import pl.edu.icm.unity.engine.api.authn.AuthenticationResult;
import pl.edu.icm.unity.engine.api.authn.AuthenticatorInstance;
import pl.edu.icm.unity.engine.api.authn.AuthenticatorInstanceMetadata;
import pl.edu.icm.unity.engine.api.authn.PartialAuthnState;
import pl.edu.icm.unity.engine.api.session.SessionParticipant;

public interface AuthenticationProcessor {
    public AuthenticatorInstance getValidAuthenticatorForEntity(Collection<AuthenticatorInstance> var1, long var2);

    public boolean checkIfUserHasCredential(AuthenticatorInstanceMetadata var1, long var2);

    public PartialAuthnState processPrimaryAuthnResult(AuthenticationResult var1, AuthenticationFlow var2, AuthenticationOptionKey var3) throws AuthenticationException;

    public AuthenticatedEntity finalizeAfterPrimaryAuthentication(PartialAuthnState var1, boolean var2);

    public AuthenticatedEntity finalizeAfterSecondaryAuthentication(PartialAuthnState var1, AuthenticationResult var2) throws AuthenticationException;

    public static List<SessionParticipant> extractParticipants(AuthenticationResult ... results) {
        ArrayList<SessionParticipant> ret = new ArrayList<SessionParticipant>();
        for (AuthenticationResult result : results) {
            if (!result.isRemote() || result.asRemote().getSuccessResult().remotePrincipal.getSessionParticipants() == null) continue;
            ret.addAll(result.asRemote().getSuccessResult().remotePrincipal.getSessionParticipants());
        }
        return ret;
    }
}

