/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.endpoint;

import java.net.URL;
import pl.edu.icm.unity.base.exceptions.EngineException;
import pl.edu.icm.unity.engine.api.endpoint.AbstractEndpoint;
import pl.edu.icm.unity.engine.api.endpoint.WebAppEndpointInstance;
import pl.edu.icm.unity.engine.api.server.AdvertisedAddressProvider;
import pl.edu.icm.unity.engine.api.server.NetworkServer;

public abstract class AbstractWebEndpoint
extends AbstractEndpoint {
    protected final NetworkServer httpServer;
    protected final AdvertisedAddressProvider advertisedAddrProvider;

    public AbstractWebEndpoint(NetworkServer httpServer, AdvertisedAddressProvider advertisedAddrProvider) {
        this.httpServer = httpServer;
        this.advertisedAddrProvider = advertisedAddrProvider;
    }

    public URL getBaseUrl() {
        return this.advertisedAddrProvider.get();
    }

    public String getServletUrl(String servletPath) {
        return this.getBaseUrl().toExternalForm() + this.getEndpointDescription().getEndpoint().getContextAddress() + servletPath;
    }

    @Override
    public final void start() throws EngineException {
        this.startOverridable();
        AbstractWebEndpoint abstractWebEndpoint = this;
        if (!(abstractWebEndpoint instanceof WebAppEndpointInstance)) {
            throw new IllegalStateException("Endpoint have to implement one of WebAppEndpointEEInstance");
        }
        WebAppEndpointInstance ee10 = (WebAppEndpointInstance)((Object)abstractWebEndpoint);
        this.httpServer.deployEndpoint(ee10);
    }

    protected void startOverridable() {
    }

    @Override
    public final void destroy() throws EngineException {
        super.destroy();
        this.httpServer.undeployEndpoint(this.getEndpointDescription().getEndpoint().getName());
        this.destroyOverridable();
    }

    protected void destroyOverridable() {
    }
}

