/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.translation;

import java.util.stream.Stream;
import pl.edu.icm.unity.base.translation.ActionParameterDefinition;
import pl.edu.icm.unity.base.translation.TranslationAction;
import pl.edu.icm.unity.base.translation.TranslationActionType;

public abstract class TranslationActionInstance
extends TranslationAction {
    protected TranslationActionType actionType;

    public TranslationActionInstance(TranslationActionType actionType, String[] parameters) {
        super(actionType.getName(), parameters);
        this.actionType = actionType;
        this.checkParams();
    }

    public TranslationActionType getActionType() {
        return this.actionType;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.actionType == null ? 0 : this.actionType.hashCode());
        return result;
    }

    protected void checkParams() {
        String[] paramVal;
        ActionParameterDefinition[] paramDef = this.getActionType().getParameters();
        if (paramDef == null) {
            paramDef = new ActionParameterDefinition[]{};
        }
        if ((paramVal = this.getParameters()) == null) {
            paramVal = new String[]{};
        }
        int mandatorySize = Long.valueOf(Stream.of(paramDef).filter(d -> d.isMandatory()).count()).intValue();
        int defSize = paramDef.length;
        int valSize = paramVal.length;
        if (valSize < mandatorySize) {
            if (mandatorySize < defSize) {
                throw new IllegalArgumentException("Action require min " + defSize + " parameters");
            }
            throw new IllegalArgumentException("Action require exacly " + defSize + " parameters");
        }
        if (valSize > defSize) {
            if (defSize == 0) {
                throw new IllegalArgumentException("Action requires no parameters");
            }
            throw new IllegalArgumentException("Action require max " + defSize + " parameters");
        }
        for (int i = 0; i < defSize; ++i) {
            if (!paramDef[i].isMandatory() || i < valSize && paramVal[i] != null && !paramVal[i].isEmpty()) continue;
            throw new IllegalArgumentException("Action requires " + paramDef[i].getName() + " parameter");
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        TranslationActionInstance other = (TranslationActionInstance)((Object)obj);
        return !(this.actionType == null ? other.actionType != null : !this.actionType.equals((Object)other.actionType));
    }
}

