/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.authn;

import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import pl.edu.icm.unity.engine.api.authn.AuthenticatorTypeDescription;

public class AuthenticatorInfo {
    private String id;
    private AuthenticatorTypeDescription typeDescription;
    private String configuration;
    private Optional<String> localCredentialName;
    private Set<String> supportedBindings;

    public AuthenticatorInfo(String id, AuthenticatorTypeDescription typeDescription, String configuration, Optional<String> localCredentialName, Set<String> supportedBindings) {
        this.id = id;
        this.typeDescription = typeDescription;
        this.configuration = configuration;
        this.localCredentialName = localCredentialName;
        this.supportedBindings = supportedBindings;
    }

    AuthenticatorInfo() {
    }

    public Optional<String> getLocalCredentialName() {
        return this.localCredentialName;
    }

    public String getId() {
        return this.id;
    }

    public AuthenticatorTypeDescription getTypeDescription() {
        return this.typeDescription;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public Set<String> getSupportedBindings() {
        return new HashSet<String>(this.supportedBindings);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.localCredentialName, this.supportedBindings, this.typeDescription, this.configuration);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AuthenticatorInfo other = (AuthenticatorInfo)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.localCredentialName, other.localCredentialName) && Objects.equals(this.supportedBindings, other.supportedBindings) && Objects.equals(this.typeDescription, other.typeDescription) && Objects.equals(this.configuration, other.configuration);
    }
}

