/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.authn;

import java.util.Objects;
import java.util.Optional;
import org.springframework.util.Assert;
import pl.edu.icm.unity.base.i18n.I18nString;

public class IdPInfo {
    public final String id;
    public final Optional<String> configId;
    public final Optional<I18nString> displayedName;
    public final Optional<IdpGroup> group;

    private IdPInfo(Builder builder) {
        this.id = builder.id;
        this.configId = builder.configId;
        this.displayedName = builder.displayedName;
        this.group = builder.group;
    }

    public int hashCode() {
        return Objects.hash(this.group, this.id, this.configId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IdPInfo other = (IdPInfo)obj;
        return Objects.equals(this.group, other.group) && Objects.equals(this.id, other.id) && Objects.equals(this.configId, other.configId);
    }

    public String toString() {
        return "IdPInfo [id=" + this.id + (String)(!this.displayedName.isEmpty() ? ", displayedName=" + this.displayedName.orElse(new I18nString()) : "") + (String)(!this.group.isEmpty() ? ", group=" + this.group.get() + ", maxElements=" : "") + ", configId=" + this.configId.orElse("") + "]";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Optional<String> configId = Optional.empty();
        private Optional<I18nString> displayedName = Optional.empty();
        private Optional<IdpGroup> group = Optional.empty();

        private Builder() {
        }

        public Builder withId(String id) {
            this.id = id;
            return this;
        }

        public Builder withConfigId(String configId) {
            this.configId = Optional.ofNullable(configId);
            return this;
        }

        public Builder withDisplayedName(I18nString displayedName) {
            this.displayedName = Optional.ofNullable(displayedName);
            return this;
        }

        public Builder withGroup(IdpGroup group) {
            this.group = Optional.ofNullable(group);
            return this;
        }

        public IdPInfo build() {
            Assert.notNull((Object)this.id, (String)"id cannot be null.");
            return new IdPInfo(this);
        }
    }

    public static class IdpGroup {
        public final String id;
        public final Optional<String> displayedName;

        public IdpGroup(String id, Optional<String> displayedName) {
            this.id = id;
            this.displayedName = displayedName;
        }

        public String toString() {
            return "IdpGroup [id=" + this.id + (String)(!this.displayedName.isEmpty() ? ", displayedName=" + this.displayedName.get() : "") + "]";
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IdpGroup other = (IdpGroup)obj;
            return Objects.equals(this.id, other.id);
        }
    }
}

