/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.authn;

import com.google.common.base.Preconditions;
import java.util.Optional;
import pl.edu.icm.unity.engine.api.authn.AuthenticatedEntity;
import pl.edu.icm.unity.engine.api.authn.AuthenticationResult;
import pl.edu.icm.unity.engine.api.authn.LocalAuthenticationResult;
import pl.edu.icm.unity.engine.api.authn.remote.RemotelyAuthenticatedPrincipal;

public class RemoteAuthenticationResult
implements AuthenticationResult {
    private final AuthenticationResult.Status status;
    private final RemoteSuccessResult successResult;
    private final LocalAuthenticationResult.NotApplicableResult notApplicableResult;
    private final UnknownRemotePrincipalResult unknownRemotePrincipalResult;
    private final RemoteErrorResult errorResult;

    private RemoteAuthenticationResult(AuthenticationResult.Status status, RemoteSuccessResult successResult, LocalAuthenticationResult.NotApplicableResult notApplicableResult, UnknownRemotePrincipalResult unknownRemotePrincipalResult, RemoteErrorResult errorResult) {
        this.status = status;
        this.successResult = successResult;
        this.notApplicableResult = notApplicableResult;
        this.unknownRemotePrincipalResult = unknownRemotePrincipalResult;
        this.errorResult = errorResult;
    }

    protected RemoteAuthenticationResult(RemoteAuthenticationResult toClone) {
        this(toClone.status, toClone.successResult, toClone.notApplicableResult, toClone.unknownRemotePrincipalResult, toClone.errorResult);
    }

    public static RemoteAuthenticationResult notApplicable() {
        return new RemoteAuthenticationResult(AuthenticationResult.Status.notApplicable, null, new LocalAuthenticationResult.NotApplicableResult(), null, null);
    }

    public static RemoteAuthenticationResult failed(RemotelyAuthenticatedPrincipal remotePrincipal, Exception cause, AuthenticationResult.ResolvableError error) {
        return new RemoteAuthenticationResult(AuthenticationResult.Status.deny, null, null, null, new RemoteErrorResult(error, cause, remotePrincipal));
    }

    public static RemoteAuthenticationResult failed(RemotelyAuthenticatedPrincipal remotePrincipal, AuthenticationResult.ResolvableError error) {
        return RemoteAuthenticationResult.failed(remotePrincipal, null, error);
    }

    public static RemoteAuthenticationResult failed() {
        return RemoteAuthenticationResult.failed(null);
    }

    public static RemoteAuthenticationResult failed(Exception cause) {
        return RemoteAuthenticationResult.failed(null, cause, AuthenticationResult.ResolvableError.EMPTY);
    }

    public static RemoteAuthenticationResult successful(RemotelyAuthenticatedPrincipal remotePrincipal, AuthenticatedEntity authenticatedEntity) {
        Preconditions.checkNotNull((Object)authenticatedEntity);
        Preconditions.checkNotNull((Object)remotePrincipal);
        return new RemoteAuthenticationResult(AuthenticationResult.Status.success, new RemoteSuccessResult(authenticatedEntity, remotePrincipal), null, null, null);
    }

    public static RemoteAuthenticationResult successfulPartial(RemotelyAuthenticatedPrincipal remotePrincipal, AuthenticatedEntity authenticatedEntity) {
        Preconditions.checkNotNull((Object)remotePrincipal);
        return new RemoteAuthenticationResult(AuthenticationResult.Status.success, new RemoteSuccessResult(authenticatedEntity, remotePrincipal), null, null, null);
    }

    public static RemoteAuthenticationResult unknownRemotePrincipal(RemotelyAuthenticatedPrincipal remotePrincipal, String formForUnknownPrincipal, boolean enableAssociation) {
        Preconditions.checkNotNull((Object)remotePrincipal);
        return new RemoteAuthenticationResult(AuthenticationResult.Status.unknownRemotePrincipal, null, null, new UnknownRemotePrincipalResult(remotePrincipal, formForUnknownPrincipal, enableAssociation), null);
    }

    @Override
    public AuthenticationResult.Status getStatus() {
        return this.status;
    }

    @Override
    public boolean isRemote() {
        return true;
    }

    @Override
    public RemoteSuccessResult getSuccessResult() {
        if (this.status != AuthenticationResult.Status.success) {
            throw new IllegalStateException("Can be aonly called on successful result, but we are " + this.status);
        }
        return this.successResult;
    }

    public LocalAuthenticationResult.NotApplicableResult getNotApplicableResult() {
        if (this.status != AuthenticationResult.Status.notApplicable) {
            throw new IllegalStateException("Can be aonly called on notApplicable result, but we are " + this.status);
        }
        return this.notApplicableResult;
    }

    public UnknownRemotePrincipalResult getUnknownRemotePrincipalResult() {
        if (this.status != AuthenticationResult.Status.unknownRemotePrincipal) {
            throw new IllegalStateException("Can be aonly called on unknownRemotePrincipal result, but we are " + this.status);
        }
        return this.unknownRemotePrincipalResult;
    }

    @Override
    public RemoteErrorResult getErrorResult() {
        if (this.status != AuthenticationResult.Status.deny) {
            throw new IllegalStateException("Can be aonly called on deny result, but we are " + this.status);
        }
        return this.errorResult;
    }

    public RemotelyAuthenticatedPrincipal getRemotelyAuthenticatedPrincipal() {
        Object detail = this.getCurrentDetail();
        if (detail instanceof RemotePrincipalProvider) {
            return ((RemotePrincipalProvider)detail).getRemotelyAuthenticatedPrincipal();
        }
        throw new IllegalStateException("Can't access RemotelyAuthenticatedPrincipal on result of state " + this.status);
    }

    @Override
    public String toStringFull() {
        return "RemoteAuthenticationResult: \nstatus=" + this.status + "\ndetails=" + this.getCurrentDetail();
    }

    private Object getCurrentDetail() {
        return this.successResult != null ? this.successResult : (this.notApplicableResult != null ? this.notApplicableResult : (this.errorResult != null ? this.errorResult : this.unknownRemotePrincipalResult));
    }

    public String toString() {
        return this.status.toString();
    }

    @Override
    public Optional<AuthenticationResult.DenyReason> getDenyReason() {
        return Optional.empty();
    }

    public static class RemoteSuccessResult
    extends AuthenticationResult.SuccessResult
    implements RemotePrincipalProvider {
        public final RemotelyAuthenticatedPrincipal remotePrincipal;

        public RemoteSuccessResult(AuthenticatedEntity authenticatedEntity, RemotelyAuthenticatedPrincipal remotePrincipal) {
            super(authenticatedEntity);
            this.remotePrincipal = remotePrincipal;
        }

        @Override
        public String toString() {
            return String.format("[remoteAuthnContext=%s]", this.remotePrincipal);
        }

        @Override
        public RemotelyAuthenticatedPrincipal getRemotelyAuthenticatedPrincipal() {
            return this.remotePrincipal;
        }
    }

    public static class UnknownRemotePrincipalResult
    implements RemotePrincipalProvider {
        public final RemotelyAuthenticatedPrincipal remotePrincipal;
        public final String formForUnknownPrincipal;
        public final boolean enableAssociation;

        public UnknownRemotePrincipalResult(RemotelyAuthenticatedPrincipal remotePrincipal, String formForUnknownPrincipal, boolean enableAssociation) {
            this.remotePrincipal = remotePrincipal;
            this.formForUnknownPrincipal = formForUnknownPrincipal;
            this.enableAssociation = enableAssociation;
        }

        public String toString() {
            return String.format("[remoteAuthnContext=%s, formForUnknownPrincipal=%s, enableAssociation=%s]", this.remotePrincipal, this.formForUnknownPrincipal, this.enableAssociation);
        }

        @Override
        public RemotelyAuthenticatedPrincipal getRemotelyAuthenticatedPrincipal() {
            return this.remotePrincipal;
        }
    }

    public static class RemoteErrorResult
    extends AuthenticationResult.ErrorResult
    implements RemotePrincipalProvider {
        public final RemotelyAuthenticatedPrincipal remotePrincipal;

        RemoteErrorResult(AuthenticationResult.ResolvableError error, Exception cause, RemotelyAuthenticatedPrincipal remotePrincipal) {
            super(error, cause);
            this.remotePrincipal = remotePrincipal;
        }

        @Override
        public String toString() {
            return String.format("[remoteAuthnContext=%s, error=%s]", this.remotePrincipal, this.error);
        }

        @Override
        public RemotelyAuthenticatedPrincipal getRemotelyAuthenticatedPrincipal() {
            return this.remotePrincipal;
        }
    }

    private static interface RemotePrincipalProvider {
        public RemotelyAuthenticatedPrincipal getRemotelyAuthenticatedPrincipal();
    }
}

