/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.config;

import eu.unicore.util.configuration.ConfigurationException;
import eu.unicore.util.configuration.DocumentationReferenceMeta;
import eu.unicore.util.configuration.DocumentationReferencePrefix;
import eu.unicore.util.configuration.PropertiesHelper;
import eu.unicore.util.configuration.PropertyMD;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.logging.log4j.Logger;
import pl.edu.icm.unity.base.utils.Log;

public class UnityHttpServerConfiguration
extends PropertiesHelper {
    private static final Logger log = Log.getLogger((String)"unity.server.config", UnityHttpServerConfiguration.class);
    @DocumentationReferencePrefix
    public static final String PREFIX = "unityServer.core.httpServer.";
    public static final String HTTP_PORT = "port";
    public static final String HTTP_HOST = "host";
    public static final String ADVERTISED_HOST = "advertisedHost";
    public static final String DISABLE_TLS = "disableTLS";
    public static final String ENABLE_DOS_FILTER = "enableDoSFilter";
    public static final String DOS_FILTER_PFX = "dosFilter.";
    public static final String FAST_RANDOM = "fastRandom";
    public static final String MIN_THREADS = "minThreads";
    public static final String MAX_THREADS = "maxThreads";
    public static final String MAX_CONNECTIONS = "maxConnections";
    public static final String WANT_CLIENT_AUTHN = "wantClientAuthn";
    public static final String REQUIRE_CLIENT_AUTHN = "requireClientAuthn";
    public static final String DISABLED_CIPHER_SUITES = "disabledCipherSuites";
    public static final String DISABLED_PROTOCOLS = "disabledProtocols";
    public static final String GZIP_PREFIX = "gzip.";
    public static final String MIN_GZIP_SIZE = "gzip.minGzipSize";
    public static final String ENABLE_GZIP = "gzip.enable";
    public static final String ENABLE_HSTS = "enableHsts";
    public static final String FRAME_OPTIONS = "xFrameOptions";
    public static final String ALLOWED_TO_EMBED = "xFrameAllowed";
    public static final String MAX_IDLE_TIME = "maxIdleTime";
    public static final String SNI_HOSTNAME_CHECK = "sniHostnameChecking";
    public static final String ENABLE_CORS = "enableCORS";
    public static final String CORS_PFX = "cors.";
    public static final String CORS_ALLOWED_ORIGINS = "allowedOrigins";
    public static final String CORS_ALLOWED_METHODS = "allowedMethods";
    public static final String CORS_ALLOWED_HEADERS = "allowedHeaders";
    public static final String CORS_ALLOW_CREDENTIALS = "allowCredentials";
    public static final String CORS_EXPOSED_HEADERS = "exposedHeaders";
    public static final String CORS_PREFLIGHT_MAX_AGE = "preflightMaxAge";
    public static final String CORS_CHAIN_PREFLIGHT = "chainPreflight";
    public static final String PROXY_COUNT = "proxyCount";
    public static final String ALLOWED_IMMEDIATE_CLIENTS = "allowedClientIPs.";
    public static final String ALLOW_NOT_PROXIED_TRAFFIC = "allowNotProxiedTraffic";
    private static final String SO_LINGER_TIME = "soLingerTime";
    private static final String HIGH_LOAD_CONNECTIONS = "highLoadConnections";
    private static final String LOW_RESOURCE_MAX_IDLE_TIME = "lowResourceMaxIdleTime";
    @DocumentationReferenceMeta
    public static final Map<String, PropertyMD> defaults = new HashMap<String, PropertyMD>();

    public UnityHttpServerConfiguration(Properties source) throws ConfigurationException {
        super(PREFIX, source, defaults, log);
        String advertisedHost = this.getValue(ADVERTISED_HOST);
        if ("0.0.0.0".equals(this.getValue(HTTP_HOST)) && advertisedHost == null) {
            throw new ConfigurationException(this.getKeyDescription(ADVERTISED_HOST) + " must be set when the listen address is 0.0.0.0 (all interfaces).");
        }
        if (advertisedHost != null) {
            if (advertisedHost.contains("://")) {
                throw new ConfigurationException(this.getKeyDescription(ADVERTISED_HOST) + " must contain hostname and optionally the port, but not the protocol prefix.");
            }
            try {
                new URL("https://" + advertisedHost);
            }
            catch (MalformedURLException e) {
                throw new ConfigurationException(this.getKeyDescription(ADVERTISED_HOST) + " is invalid, URL can not be constructed from it", (Throwable)e);
            }
        }
    }

    public Set<String> getSortedStringKeys(String configKey) {
        return this.getSortedStringKeys(this.prefix + configKey, false);
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    static {
        PropertyMD.DocumentationCategory mainCat = new PropertyMD.DocumentationCategory("General settings", "1");
        PropertyMD.DocumentationCategory corsCat = new PropertyMD.DocumentationCategory("CORS settings", "7");
        PropertyMD.DocumentationCategory proxyCat = new PropertyMD.DocumentationCategory("Proxy settings", "8");
        PropertyMD.DocumentationCategory advancedCat = new PropertyMD.DocumentationCategory("Advanced settings", "9");
        defaults.put(HTTP_HOST, new PropertyMD("localhost").setCategory(mainCat).setDescription("The hostname or IP address for HTTP connections. Use 0.0.0.0 to listen on all interfaces."));
        defaults.put(HTTP_PORT, new PropertyMD("2443").setBounds(0L, 65535L).setCategory(mainCat).setDescription("The HTTP port to be used. If zero (0) is set then a random free port is used."));
        defaults.put(ADVERTISED_HOST, new PropertyMD().setCategory(mainCat).setDescription("The hostname or IP address (optionally with port), which is advertised externally whenever the server has to provide its address. By default it is set to the listen address, however it must be set when the listen address is 0.0.0.0 and also should be set whenever the server is listening on a private interface accessible via DNAT or similar solutions. Examples: +login.example.com+ or +login.example.com:8443+ "));
        defaults.put(DISABLE_TLS, new PropertyMD("false").setCategory(mainCat).setDescription("If set to true then server will listen on plain, insecure socket. Useful when Unity is hidden behind a proxy server, which provides TLS on its own. Note: it is still mandatory for web browser clients to access Unity over HTTPS as otherwise Unity cookies won't be accepted by the browser. Therefore Unity's advertised address is always be HTTPS."));
        defaults.put(PROXY_COUNT, new PropertyMD("0").setMin(0L).setMax(32L).setCategory(proxyCat).setDescription("If set to 0 then it is assumed then this server is not behind a proxy. Otherwise the number should specify the number of (local, trusted) proxies that are protecting the server from the actual clients. In effect the assumed client IP will be taken from the X-Forwarded-For header, stripping the trailing ones from intermediary proxies. Not that only proxy servers setting X-Forwarded-For are supported."));
        defaults.put(ALLOWED_IMMEDIATE_CLIENTS, new PropertyMD().setList(false).setCategory(proxyCat).setDescription("If not empty then contains a list of IPv4 or IPv6 addresses,that are allowed as immediate clients. In practice it is useful when Unity is deployed behind a proxy server: then proxy IP(s) should be entered as the only allowed IP to harden installation security. Note: CIDR notation can be used to denote networks, e.g. 10.10.0.0/16."));
        defaults.put(ALLOW_NOT_PROXIED_TRAFFIC, new PropertyMD("true").setCategory(proxyCat).setDescription("If false then only requests with X-Forwarded-For header will be accepted."));
        defaults.put(ENABLE_DOS_FILTER, new PropertyMD("false").setCategory(advancedCat).setDescription("If enabled then the DenayOfService fileter is enabled forall services. The filter prevents DoS attacks, but requires a proper configuration dependent on the installation site."));
        defaults.put(DOS_FILTER_PFX, new PropertyMD().setCanHaveSubkeys().setCategory(advancedCat).setDescription("Under this prefix the settings of the DoS filter must be placed. The reference of allowed settings is available in the Jetty DoS filter documentation, currently here: http://www.eclipse.org/jetty/documentation/current/dos-filter.html"));
        defaults.put(MAX_THREADS, new PropertyMD("255").setCategory(advancedCat).setDescription("Maximum number of threads to have in the thread pool for processing HTTP connections. Note that this number will be increased with few additional threads to handle connectors."));
        defaults.put(MIN_THREADS, new PropertyMD("1").setPositive().setCategory(advancedCat).setDescription("Minimum number of threads to have in the thread pool for processing HTTP connections.  Note that this number will be increased with few additional threads to handle connectors."));
        defaults.put(MAX_CONNECTIONS, new PropertyMD("256").setCategory(advancedCat).setDescription("Maximum number of concurrent connections the server accepts."));
        defaults.put(FAST_RANDOM, new PropertyMD("false").setCategory(advancedCat).setDescription("Use insecure, but fast pseudo random generator to generate session ids instead of secure generator for TLS sockets."));
        defaults.put(WANT_CLIENT_AUTHN, new PropertyMD("false").setCategory(advancedCat).setDescription("Controls whether the TLS socket accepts (but does not require) client-side certificate authentication."));
        defaults.put(DISABLED_CIPHER_SUITES, new PropertyMD("").setCategory(advancedCat).setDescription("Space separated list of TLS cipher suites to be disabled. Names of the ciphers must adhere to the standard Java cipher names, available here (search for Cipher Suites): https://docs.oracle.com/en/java/javase/11/security/oracle-providers.html#GUID-7093246A-31A3-4304-AC5F-5FB6400405E2"));
        defaults.put(DISABLED_PROTOCOLS, new PropertyMD("TLSv1.1 TLSv1").setCategory(advancedCat).setDescription("Space separated list of protocol variants to be disabled. Names of the protocols are in table named 'Protocol Parametrs' under the linkhttps://docs.oracle.com/en/java/javase/11/security/oracle-providers.html#GUID-7093246A-31A3-4304-AC5F-5FB6400405E2"));
        defaults.put(MIN_GZIP_SIZE, new PropertyMD("100000").setCategory(advancedCat).setDescription("Specifies the minimal size of message that should be compressed."));
        defaults.put(ENABLE_HSTS, new PropertyMD("false").setCategory(advancedCat).setDescription("Control whether HTTP strict transport security is enabled. It is a good and strongly suggested security mechanism for all production sites. At the same time it can not be used with self-signed or not issued by a generally trusted CA server certificates, as with HSTS a user can't opt in to enter such site."));
        defaults.put(FRAME_OPTIONS, new PropertyMD((Enum)XFrameOptions.deny).setCategory(advancedCat).setDescription("Defines whether a clickjacking prevention should be turned on, by insertionof the X-Frame-Options HTTP header. The 'allow' value disables the feature. See the RFC 7034 for details. Note that for the 'allowFrom' you should define also the xFrameAllowed option and it is not fully supported by all the browsers."));
        defaults.put(ALLOWED_TO_EMBED, new PropertyMD("http://localhost").setCategory(advancedCat).setDescription("URI origin that is allowed to embed web interface inside a (i)frame. Meaningful only if the xFrameOptions is set to 'allowFrom'. The value should be in the form: 'http[s]://host[:port]'"));
        defaults.put(ENABLE_GZIP, new PropertyMD("true").setCategory(advancedCat).setDescription("Controls whether to enable compression of HTTP responses."));
        defaults.put(REQUIRE_CLIENT_AUTHN, new PropertyMD("false").setCategory(advancedCat).setDescription("Controls whether the SSL socket requires client-side authentication."));
        defaults.put(MAX_IDLE_TIME, new PropertyMD("200000").setPositive().setDescription("Time (in ms.) before an idle connection will time out. It should be large enough not to expire connections with slow clients, values below 30s are getting quite risky."));
        defaults.put(ENABLE_CORS, new PropertyMD("false").setCategory(corsCat).setDescription("Control whether Cross-Origin Resource Sharing is enabled. Enable to allow e.g. accesing REST services from client-side JavaScript."));
        defaults.put(CORS_PFX, new PropertyMD().setCanHaveSubkeys().setCategory(corsCat).setDescription("Common prefix under which CORS is configured"));
        defaults.put("cors.allowedOrigins", new PropertyMD("*").setCategory(corsCat).setDescription("Allowed script origins."));
        defaults.put("cors.allowedMethods", new PropertyMD("GET,PUT,POST,DELETE,HEAD").setCategory(corsCat).setDescription("Comma separated list of allowed HTTP verbs."));
        defaults.put("cors.allowedHeaders", new PropertyMD("*").setCategory(corsCat).setDescription("Comma separated list of allowed HTTP headers (default: any)"));
        defaults.put("cors.allowCredentials", new PropertyMD("true").setCategory(corsCat).setDescription("Whether the server allows requests with credentials"));
        defaults.put("cors.preflightMaxAge", new PropertyMD("1800").setCategory(corsCat).setDescription("The number of seconds that preflight requests can be cached by the client."));
        defaults.put("cors.exposedHeaders", new PropertyMD("Location,Content-Type").setCategory(corsCat).setDescription("Comma separated list of HTTP headers that are allowed to be exposed to the client."));
        defaults.put("cors.chainPreflight", new PropertyMD("false").setCategory(corsCat).setDescription("Whether preflight OPTION requests are chained (passed on) to the resource or handled via the CORS filter."));
        defaults.put(SO_LINGER_TIME, new PropertyMD().setDeprecated().setDescription("Not used anymore with non-blocking server connectors. Please remove from configuration."));
        defaults.put(HIGH_LOAD_CONNECTIONS, new PropertyMD().setDeprecated().setDescription("Deprecated and ignored. Use maxConnections option instead."));
        defaults.put(LOW_RESOURCE_MAX_IDLE_TIME, new PropertyMD().setDeprecated().setDescription("Not used anymore without a counterpart"));
        defaults.put(SNI_HOSTNAME_CHECK, new PropertyMD("false").setHidden().setDescription("Allows for turning off the SNI hostname checking"));
    }

    public static enum XFrameOptions {
        deny("DENY"),
        sameOrigin("SAMEORIGIN"),
        allowFrom("ALLOW-FROM"),
        allow("");

        private String httpValue;

        private XFrameOptions(String httpValue) {
            this.httpValue = httpValue;
        }

        public String toHttp() {
            return this.httpValue;
        }
    }
}

