/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.endpoint;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import pl.edu.icm.unity.base.endpoint.ResolvedEndpoint;
import pl.edu.icm.unity.base.exceptions.EngineException;
import pl.edu.icm.unity.engine.api.authn.AuthenticationFlow;
import pl.edu.icm.unity.engine.api.endpoint.EndpointInstance;

public abstract class AbstractEndpoint
implements EndpointInstance {
    protected ResolvedEndpoint description;
    protected List<AuthenticationFlow> authenticationFlows;
    protected Properties properties;

    @Override
    public synchronized void initialize(ResolvedEndpoint description, List<AuthenticationFlow> authenticators, String serializedConfiguration) {
        this.description = description;
        this.authenticationFlows = authenticators;
        this.setSerializedConfiguration(serializedConfiguration);
    }

    @Override
    public String getSerializedConfiguration() {
        CharArrayWriter writer = new CharArrayWriter();
        try {
            this.properties.store(writer, "");
        }
        catch (IOException e) {
            throw new IllegalStateException("Can not serialize endpoint's configuration", e);
        }
        return writer.toString();
    }

    protected abstract void setSerializedConfiguration(String var1);

    @Override
    public ResolvedEndpoint getEndpointDescription() {
        return this.description;
    }

    @Override
    public void destroy() throws EngineException {
        for (AuthenticationFlow ao : this.authenticationFlows) {
            ao.destroy();
        }
    }

    @Override
    public synchronized List<AuthenticationFlow> getAuthenticationFlows() {
        return this.authenticationFlows;
    }

    protected synchronized void setAuthenticators(List<AuthenticationFlow> authenticationFlows) {
        this.authenticationFlows = new ArrayList<AuthenticationFlow>(authenticationFlows);
    }
}

