/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.finalization;

import java.time.Duration;

public class WorkflowFinalizationConfiguration {
    public final boolean success;
    public final boolean autoRedirect;
    public final String pageTitle;
    public final String logoURL;
    public final String mainInformation;
    public final String extraInformation;
    public final String redirectURL;
    public final String redirectButtonText;
    public final Duration redirectAfterTime;
    private boolean isAutoLoginAfterSignUp;

    public WorkflowFinalizationConfiguration(boolean success, boolean autoRedirect, String pageTitle, String logoURL, String mainInformation, String extraInformation, String redirectURL, String redirectButtonText, Duration redirectAfterTime) {
        this.success = success;
        this.autoRedirect = autoRedirect;
        this.pageTitle = pageTitle;
        this.logoURL = logoURL;
        this.mainInformation = mainInformation;
        this.extraInformation = extraInformation;
        this.redirectURL = redirectURL;
        this.redirectButtonText = redirectButtonText;
        this.redirectAfterTime = redirectAfterTime;
    }

    public boolean isAutoLoginAfterSignUp() {
        return this.isAutoLoginAfterSignUp;
    }

    public void setAutoLoginAfterSignUp(boolean isAutoLoginAfterSignUp) {
        this.isAutoLoginAfterSignUp = isAutoLoginAfterSignUp;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static WorkflowFinalizationConfiguration autoRedirect(String redirectURL) {
        return new Builder().setAutoRedirect(true).setRedirectURL(redirectURL).build();
    }

    public static WorkflowFinalizationConfiguration basicError(String mainInfo, String redirectURL) {
        return new Builder().setSuccess(false).setMainInformation(mainInfo).setRedirectURL(redirectURL).build();
    }

    public String toString() {
        return "WorkflowFinalizationConfiguration [success=" + this.success + ", autoRedirect=" + this.autoRedirect + ", pageTitle=" + this.pageTitle + ", logoURL=" + this.logoURL + ", mainInformation=" + this.mainInformation + ", extraInformation=" + this.extraInformation + ", redirectURL=" + this.redirectURL + ", redirectButtonText=" + this.redirectButtonText + ", redirectAfterTime=" + this.redirectAfterTime + ", isAutoLoginAfterSignUp=" + this.isAutoLoginAfterSignUp + "]";
    }

    public static class Builder {
        private boolean success;
        private boolean autoRedirect;
        private String pageTitle;
        private String logoURL;
        private String mainInformation;
        private String extraInformation;
        private String redirectURL;
        private String redirectButtonText;
        private Duration redirectAfter;

        public Builder setSuccess(boolean success) {
            this.success = success;
            return this;
        }

        public Builder setAutoRedirect(boolean autoRedirect) {
            this.autoRedirect = autoRedirect;
            return this;
        }

        public Builder setPageTitle(String pageTitle) {
            this.pageTitle = pageTitle;
            return this;
        }

        public Builder setLogoURL(String logoURL) {
            this.logoURL = logoURL;
            return this;
        }

        public Builder setMainInformation(String mainInformation) {
            this.mainInformation = mainInformation;
            return this;
        }

        public Builder setExtraInformation(String extraInformation) {
            this.extraInformation = extraInformation;
            return this;
        }

        public Builder setRedirectURL(String redirectURL) {
            this.redirectURL = redirectURL;
            return this;
        }

        public Builder setRedirectButtonText(String redirectButtonText) {
            this.redirectButtonText = redirectButtonText;
            return this;
        }

        public Builder setRedirectAfter(Duration redirectAfter) {
            this.redirectAfter = redirectAfter;
            return this;
        }

        public WorkflowFinalizationConfiguration build() {
            return new WorkflowFinalizationConfiguration(this.success, this.autoRedirect, this.pageTitle, this.logoURL, this.mainInformation, this.extraInformation, this.redirectURL, this.redirectButtonText, this.redirectAfter);
        }
    }
}

