/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.version;

import java.time.Instant;
import java.util.Objects;

public class VersionInformation {
    public final String version;
    public final Instant buildTime;

    private VersionInformation(Builder builder) {
        this.version = builder.version;
        this.buildTime = builder.buildTime;
    }

    public int hashCode() {
        return Objects.hash(this.buildTime, this.version);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VersionInformation other = (VersionInformation)obj;
        return Objects.equals(this.buildTime, other.buildTime) && Objects.equals(this.version, other.version);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String version;
        private Instant buildTime;

        private Builder() {
        }

        public Builder withVersion(String version) {
            this.version = version;
            return this;
        }

        public Builder withBuildTime(Instant buildTime) {
            this.buildTime = buildTime;
            return this;
        }

        public VersionInformation build() {
            return new VersionInformation(this);
        }
    }
}

