/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.entity;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import pl.edu.icm.unity.base.entity.Entity;

public class EntityWithContactInfo {
    public final Entity entity;
    public final String contactEmail;
    public final Set<String> groups;

    public EntityWithContactInfo(Entity entity, String contactEmail, Set<String> groups) {
        this.entity = entity;
        this.contactEmail = contactEmail;
        this.groups = Optional.ofNullable(groups).map(Set::copyOf).orElse(null);
    }

    public int hashCode() {
        return Objects.hash(this.contactEmail, this.entity, this.groups);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EntityWithContactInfo other = (EntityWithContactInfo)obj;
        return Objects.equals(this.contactEmail, other.contactEmail) && Objects.equals(this.entity, other.entity) && Objects.equals(this.groups, other.groups);
    }
}

