/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.project;

import com.google.common.base.Objects;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import pl.edu.icm.unity.base.exceptions.EngineException;
import pl.edu.icm.unity.base.registration.BaseForm;
import pl.edu.icm.unity.base.registration.GroupSelection;
import pl.edu.icm.unity.base.registration.invitation.FormPrefill;
import pl.edu.icm.unity.base.registration.invitation.InvitationWithCode;
import pl.edu.icm.unity.base.registration.invitation.PrefilledEntry;
import pl.edu.icm.unity.engine.api.project.ProjectInvitationParam;

public class ProjectInvitation
extends ProjectInvitationParam {
    public static final long DEFAULT_TTL_DAYS = 3L;
    public final String registrationCode;
    public final Instant lastSentTime;
    public final int numberOfSends;
    public final String link;

    public ProjectInvitation(String project, BaseForm form, InvitationWithCode org, String link) throws EngineException {
        super(project, org.getInvitation().getContactAddress(), ProjectInvitation.getGroups(org, form), org.getInvitation().getPrefillForForm(form).getAllowedGroups() != null && !org.getInvitation().getPrefillForForm(form).getAllowedGroups().isEmpty(), org.getInvitation().getExpiration());
        this.registrationCode = org.getRegistrationCode();
        this.lastSentTime = org.getLastSentTime();
        this.numberOfSends = org.getNumberOfSends();
        this.link = link;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.registrationCode, this.lastSentTime, this.numberOfSends, this.link});
    }

    private static List<String> getGroups(InvitationWithCode org, BaseForm form) throws EngineException {
        FormPrefill invParam = org.getInvitation().getPrefillForForm(form);
        if ((invParam.getAllowedGroups() == null || invParam.getAllowedGroups().isEmpty()) && (invParam.getGroupSelections() == null || invParam.getGroupSelections().isEmpty())) {
            return Collections.emptyList();
        }
        return !invParam.getAllowedGroups().isEmpty() ? ((GroupSelection)invParam.getAllowedGroups().get(0)).getSelectedGroups() : ((GroupSelection)((PrefilledEntry)invParam.getGroupSelections().get(0)).getEntry()).getSelectedGroups();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProjectInvitation other = (ProjectInvitation)obj;
        if (!super.equals(obj)) {
            return false;
        }
        return Objects.equal((Object)this.registrationCode, (Object)other.registrationCode) && Objects.equal((Object)this.lastSentTime, (Object)other.lastSentTime) && Objects.equal((Object)this.numberOfSends, (Object)other.numberOfSends) && Objects.equal((Object)this.link, (Object)other.link);
    }
}

