/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.session;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Logger;
import pl.edu.icm.unity.base.exceptions.InternalException;
import pl.edu.icm.unity.base.utils.Log;
import pl.edu.icm.unity.engine.api.session.SessionManagement;
import pl.edu.icm.unity.engine.api.session.SessionParticipant;
import pl.edu.icm.unity.engine.api.session.SessionParticipantType;
import pl.edu.icm.unity.engine.api.session.SessionParticipantTypesRegistry;

public class SessionParticipants {
    public static final String KEY = "sessionParticipants";
    private Set<SessionParticipant> participants = new HashSet<SessionParticipant>();
    private ObjectMapper jsonMapper = new ObjectMapper();
    private SessionParticipantTypesRegistry registry;

    public SessionParticipants(String serializedState, SessionParticipantTypesRegistry registry) {
        this.registry = registry;
        try {
            ArrayNode root = (ArrayNode)this.jsonMapper.readTree(serializedState);
            for (int i = 0; i < root.size(); ++i) {
                ObjectNode entry = (ObjectNode)root.get(i);
                String type = entry.get("type").asText();
                String entryValue = entry.get("value").asText();
                SessionParticipantType factory = (SessionParticipantType)registry.getByName(type);
                this.participants.add(factory.getInstance(entryValue));
            }
        }
        catch (Exception e) {
            throw new InternalException("Can not deserialize session participants from JSON", (Throwable)e);
        }
    }

    public SessionParticipants(SessionParticipantTypesRegistry registry) {
        this.registry = registry;
    }

    public static SessionParticipants getFromSession(Map<String, String> sessionAttributes, SessionParticipantTypesRegistry registry) {
        String participantsSerialized = sessionAttributes.get(KEY);
        return participantsSerialized == null ? new SessionParticipants(registry) : new SessionParticipants(participantsSerialized, registry);
    }

    public String serialize() {
        try {
            ArrayNode root = this.jsonMapper.createArrayNode();
            for (SessionParticipant sp : this.participants) {
                ObjectNode entry = root.addObject();
                entry.put("type", sp.getProtocolType());
                SessionParticipantType factory = (SessionParticipantType)this.registry.getByName(sp.getProtocolType());
                entry.put("value", factory.serialize(sp));
            }
            return this.jsonMapper.writeValueAsString((Object)root);
        }
        catch (IOException e) {
            throw new InternalException("Can not serialize session participants to JSON", (Throwable)e);
        }
    }

    public void addParticipant(SessionParticipant participant) {
        this.participants.add(participant);
    }

    public void removeParticipant(SessionParticipant participant) {
        this.participants.remove(participant);
    }

    public Set<SessionParticipant> getParticipants() {
        HashSet<SessionParticipant> ret = new HashSet<SessionParticipant>(this.participants);
        return ret;
    }

    public String toString() {
        return this.participants.toString();
    }

    public static class AddParticipantToSessionTask
    implements SessionManagement.AttributeUpdater {
        private static final Logger log = Log.getLogger((String)"unity.server.authn", AddParticipantToSessionTask.class);
        private SessionParticipant[] toBeAdded;
        private SessionParticipantTypesRegistry registry;

        public AddParticipantToSessionTask(SessionParticipantTypesRegistry registry, SessionParticipant ... toBeAdded) {
            this.toBeAdded = toBeAdded;
            this.registry = registry;
        }

        @Override
        public void updateAttributes(Map<String, String> sessionAttributes) {
            SessionParticipants participants = SessionParticipants.getFromSession(sessionAttributes, this.registry);
            for (SessionParticipant p : this.toBeAdded) {
                participants.addParticipant(p);
            }
            if (log.isDebugEnabled()) {
                log.info("Updated session participants to: " + String.valueOf(participants));
            }
            sessionAttributes.put(SessionParticipants.KEY, participants.serialize());
        }
    }
}

