/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.attributes;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Optional;
import pl.edu.icm.unity.base.attribute.IllegalAttributeValueException;
import pl.edu.icm.unity.base.confirmation.EmailConfirmationConfiguration;
import pl.edu.icm.unity.engine.api.attributes.PublicAttributeSpec;

public interface AttributeValueSyntax<T> {
    public JsonNode getSerializedConfiguration();

    public void setSerializedConfiguration(JsonNode var1);

    public String getValueSyntaxId();

    public void validate(T var1) throws IllegalAttributeValueException;

    default public void validateStringValue(String value) throws IllegalAttributeValueException {
        this.validate(this.convertFromString(value));
    }

    public boolean areEqual(T var1, Object var2);

    default public boolean areEqualStringValue(String value, String another) {
        return this.areEqual(this.convertFromString(value), this.convertFromString(another));
    }

    public int hashCode(Object var1);

    default public String serializeSimple(T value) {
        return this.convertToString(value);
    }

    default public T deserializeSimple(String value) throws IllegalAttributeValueException {
        try {
            T ret = this.convertFromString(value);
            this.validate(ret);
            return ret;
        }
        catch (Exception e) {
            throw new IllegalAttributeValueException(value + " can not be deserialized to " + this.getValueSyntaxId(), (Throwable)e);
        }
    }

    public T convertFromString(String var1);

    public String convertToString(T var1);

    public boolean isEmailVerifiable();

    public boolean isUserVerifiable();

    default public int getMaxSize() {
        return 0;
    }

    default public Optional<EmailConfirmationConfiguration> getEmailConfirmationConfiguration() {
        return Optional.empty();
    }

    default public Optional<PublicAttributeSpec> publicExposureSpec() {
        return Optional.empty();
    }
}

