/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.authn;

import java.time.Instant;
import java.util.Optional;
import pl.edu.icm.unity.base.authn.AuthenticationMethod;
import pl.edu.icm.unity.engine.api.authn.AuthenticatedEntity;
import pl.edu.icm.unity.engine.api.authn.AuthenticationResult;

public class LocalAuthenticationResult
implements AuthenticationResult {
    private final AuthenticationResult.Status status;
    private final AuthenticationResult.SuccessResult successResult;
    private final NotApplicableResult notApplicableResult;
    private final AuthenticationResult.ErrorResult errorResult;
    private final AuthenticationResult.DenyReason denyReason;

    private LocalAuthenticationResult(AuthenticationResult.Status status, AuthenticationResult.SuccessResult successResult, NotApplicableResult notApplicableResult, AuthenticationResult.ErrorResult errorResult, AuthenticationResult.DenyReason denyReason) {
        this.status = status;
        this.successResult = successResult;
        this.notApplicableResult = notApplicableResult;
        this.errorResult = errorResult;
        this.denyReason = denyReason;
    }

    public static LocalAuthenticationResult failed() {
        return LocalAuthenticationResult.failed(AuthenticationResult.ResolvableError.EMPTY, null, null);
    }

    public static LocalAuthenticationResult failed(Exception cause) {
        return LocalAuthenticationResult.failed(AuthenticationResult.ResolvableError.EMPTY, cause);
    }

    public static LocalAuthenticationResult failed(Exception cause, AuthenticationResult.DenyReason denyReason) {
        return LocalAuthenticationResult.failed(AuthenticationResult.ResolvableError.EMPTY, cause, denyReason);
    }

    public static LocalAuthenticationResult failed(AuthenticationResult.ResolvableError error) {
        return LocalAuthenticationResult.failed(error, null, null);
    }

    public static LocalAuthenticationResult failed(AuthenticationResult.ResolvableError error, AuthenticationResult.DenyReason denyReason) {
        return LocalAuthenticationResult.failed(error, null, denyReason);
    }

    public static LocalAuthenticationResult failed(AuthenticationResult.ResolvableError error, Exception cause, AuthenticationResult.DenyReason denyReason) {
        return new LocalAuthenticationResult(AuthenticationResult.Status.deny, null, null, new AuthenticationResult.ErrorResult(error, cause), denyReason);
    }

    public static LocalAuthenticationResult failed(AuthenticationResult.ResolvableError error, Exception cause) {
        return new LocalAuthenticationResult(AuthenticationResult.Status.deny, null, null, new AuthenticationResult.ErrorResult(error, cause), null);
    }

    public static LocalAuthenticationResult notApplicable() {
        return new LocalAuthenticationResult(AuthenticationResult.Status.notApplicable, null, new NotApplicableResult(), null, null);
    }

    public static LocalAuthenticationResult successful(AuthenticatedEntity authenticatedEntity, AuthenticationMethod authenticationMethod) {
        return new LocalAuthenticationResult(AuthenticationResult.Status.success, new AuthenticationResult.SuccessResult(authenticatedEntity, authenticationMethod, Instant.now()), null, null, null);
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    @Override
    public AuthenticationResult.Status getStatus() {
        return this.status;
    }

    @Override
    public AuthenticationResult.SuccessResult getSuccessResult() {
        if (this.status != AuthenticationResult.Status.success) {
            throw new IllegalStateException("Can be aonly called on successful result, but we are " + String.valueOf((Object)this.status));
        }
        return this.successResult;
    }

    public NotApplicableResult getNotApplicableResult() {
        if (this.status != AuthenticationResult.Status.notApplicable) {
            throw new IllegalStateException("Can be aonly called on notApplicable result, but we are " + String.valueOf((Object)this.status));
        }
        return this.notApplicableResult;
    }

    @Override
    public AuthenticationResult.ErrorResult getErrorResult() {
        if (this.status != AuthenticationResult.Status.deny) {
            throw new IllegalStateException("Can be aonly called on deny result, but we are " + String.valueOf((Object)this.status));
        }
        return this.errorResult;
    }

    @Override
    public String toStringFull() {
        AuthenticationResult.SuccessResult detail = this.successResult != null ? this.successResult : (this.notApplicableResult != null ? this.notApplicableResult : this.errorResult);
        return "AuthenticationResult: \nstatus=" + String.valueOf((Object)this.status) + "\ndetails=" + String.valueOf(detail);
    }

    public String toString() {
        return this.status.toString();
    }

    @Override
    public Optional<AuthenticationResult.DenyReason> getDenyReason() {
        return Optional.ofNullable(this.denyReason);
    }

    public static class NotApplicableResult {
        public String toString() {
            return "-not applicable-";
        }
    }
}

