/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.authn;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import pl.edu.icm.unity.engine.api.authn.RemoteAuthnMetadata;

@JsonDeserialize(builder=Builder.class)
public class SerializableRemoteAuthnMetadata {
    public final RemoteAuthnMetadata.Protocol protocol;
    public final String remoteIdPId;
    public final List<String> classReferences;

    private SerializableRemoteAuthnMetadata(Builder builder) {
        this.protocol = builder.protocol;
        this.remoteIdPId = builder.remoteIdPId;
        this.classReferences = List.copyOf(builder.classReferences);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.classReferences, this.protocol, this.remoteIdPId});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SerializableRemoteAuthnMetadata other = (SerializableRemoteAuthnMetadata)obj;
        return Objects.equals(this.classReferences, other.classReferences) && this.protocol == other.protocol && Objects.equals(this.remoteIdPId, other.remoteIdPId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private RemoteAuthnMetadata.Protocol protocol;
        private String remoteIdPId;
        private List<String> classReferences = Collections.emptyList();

        private Builder() {
        }

        public Builder withProtocol(RemoteAuthnMetadata.Protocol protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder withRemoteIdPId(String remoteIdPId) {
            this.remoteIdPId = remoteIdPId;
            return this;
        }

        public Builder withClassReferences(List<String> classReferences) {
            this.classReferences = classReferences;
            return this;
        }

        public SerializableRemoteAuthnMetadata build() {
            return new SerializableRemoteAuthnMetadata(this);
        }
    }
}

