/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.authn.remote;

import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import pl.edu.icm.unity.base.utils.Log;
import pl.edu.icm.unity.engine.api.authn.remote.RelayedAuthnState;

public class RemoteAuthenticationContextManagement<T extends RelayedAuthnState> {
    private static final Logger log = Log.getLogger((String)"unity.server.authn", RemoteAuthenticationContextManagement.class);
    private static final Duration DEF_CLEANUP_INTERVAL = Duration.ofMinutes(5L);
    private static final Duration DEF_SHORT_CLEANUP_INTERVAL = Duration.ofSeconds(5L);
    private final Map<String, T> contexts = new HashMap<String, T>();
    private LocalDateTime lastCleanup = LocalDateTime.now();
    private final Duration maxTTL;
    private final Duration cleanupInterval;

    public RemoteAuthenticationContextManagement(Duration maxTTL) {
        this(maxTTL, DEF_CLEANUP_INTERVAL);
    }

    public RemoteAuthenticationContextManagement(Duration maxTTL, Duration cleanupInterval) {
        this.maxTTL = maxTTL;
        this.cleanupInterval = cleanupInterval.compareTo(maxTTL) > 0 ? DEF_SHORT_CLEANUP_INTERVAL : cleanupInterval;
        log.debug("Stale authn context will be cleaned after {}, interval is {}", (Object)maxTTL, (Object)this.cleanupInterval);
    }

    public synchronized void addAuthnContext(T context) {
        this.cleanup();
        String relayState = ((RelayedAuthnState)context).getRelayState();
        if (this.contexts.containsKey(relayState)) {
            throw new IllegalArgumentException("Ups, the relay state " + relayState + " is already assigned");
        }
        this.contexts.put(relayState, context);
    }

    public synchronized T getAndRemoveAuthnContext(String relayState) {
        this.cleanup();
        RelayedAuthnState ret = (RelayedAuthnState)this.contexts.remove(relayState);
        if (ret == null) {
            throw new UnboundRelayStateException(relayState);
        }
        return (T)ret;
    }

    private void cleanup() {
        LocalDateTime now = LocalDateTime.now();
        if (now.minus(this.cleanupInterval).isBefore(this.lastCleanup)) {
            return;
        }
        this.lastCleanup = LocalDateTime.now();
        LocalDateTime oldestAllowed = now.minus(this.maxTTL);
        Date oldestAllowedDate = Date.from(oldestAllowed.atZone(ZoneId.systemDefault()).toInstant());
        Iterator<T> it = this.contexts.values().iterator();
        while (it.hasNext()) {
            RelayedAuthnState ctx = (RelayedAuthnState)it.next();
            if (!ctx.getCreationTime().before(oldestAllowedDate)) continue;
            log.debug("Dropping stale since {} authN context: {}", (Object)ctx.getCreationTime(), (Object)ctx);
            it.remove();
        }
    }

    public static class UnboundRelayStateException
    extends RuntimeException {
        public UnboundRelayStateException(String relayState) {
            super("The relay state " + relayState + " is not assigned");
        }
    }
}

