/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.config;

import eu.unicore.util.configuration.PropertiesHelper;
import eu.unicore.util.configuration.PropertyMD;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Logger;
import pl.edu.icm.unity.base.exceptions.InternalException;
import pl.edu.icm.unity.base.i18n.I18nString;
import pl.edu.icm.unity.base.message.MessageSource;

public class UnityPropertiesHelper
extends PropertiesHelper {
    private Set<Pattern> cachedPrefixes = new HashSet<Pattern>();
    protected Map<String, Set<String>> listKeysCache = new HashMap<String, Set<String>>();

    public UnityPropertiesHelper(String prefix, Properties properties, Map<String, PropertyMD> propertiesMD, Logger log) {
        super(prefix, properties, propertiesMD, log);
    }

    protected UnityPropertiesHelper(UnityPropertiesHelper cloned) {
        super((PropertiesHelper)cloned);
        this.cachedPrefixes.addAll(cloned.cachedPrefixes);
        this.listKeysCache.putAll(cloned.listKeysCache);
    }

    public void addCachedPrefixes(String ... prefixRegexp) {
        for (String prefix : prefixRegexp) {
            this.cachedPrefixes.add(Pattern.compile(prefix));
        }
        this.refillCache();
    }

    public synchronized void setProperties(Properties properties) {
        super.setProperties(properties);
        this.refillCache();
    }

    public synchronized void setProperty(String key, String value) {
        super.setProperty(key, value);
        this.cacheIfNeeded(this.prefix + key);
    }

    protected void refillCache() {
        this.listKeysCache.clear();
        for (Object key : this.properties.keySet()) {
            this.cacheIfNeeded((String)key);
        }
    }

    protected void cacheIfNeeded(String key) {
        for (Pattern pattern : this.cachedPrefixes) {
            Matcher matcher = pattern.matcher(key);
            if (!matcher.find() || matcher.start() != 0) continue;
            String matchedPfx = matcher.group();
            Set<String> set = this.listKeysCache.get(matchedPfx);
            if (set == null) {
                set = new HashSet<String>();
                this.listKeysCache.put(matchedPfx, set);
            }
            set.add(key);
        }
    }

    protected boolean isCached(String key) {
        if (this.cachedPrefixes == null) {
            return false;
        }
        for (Pattern pattern : this.cachedPrefixes) {
            Matcher matcher = pattern.matcher(key);
            if (!matcher.find() || matcher.start() != 0) continue;
            return true;
        }
        return false;
    }

    protected synchronized Set<String> getSortedStringKeys(String base, boolean allowListSubKeys) {
        Set<Object> allKeys;
        TreeSet<String> keys = new TreeSet<String>();
        Set<Object> set = allKeys = this.isCached(base) ? this.listKeysCache.get(base) : this.properties.keySet();
        if (allKeys == null) {
            return Collections.emptySet();
        }
        for (Object keyO : allKeys) {
            String key = (String)keyO;
            if (!key.startsWith(base)) continue;
            String post = key.substring(base.length());
            int dot = post.indexOf(46);
            if (dot != -1 && allowListSubKeys) {
                post = post.substring(0, dot);
            } else if (dot != -1 && !allowListSubKeys) {
                this.log.warn("Property list key '" + key + "' should not posses a dot: '" + post + "'. Ignoring.");
                continue;
            }
            keys.add(base + post);
        }
        return keys;
    }

    public I18nString getLocalizedString(MessageSource msg, String baseKey) {
        return UnityPropertiesHelper.getLocalizedString(this, msg, baseKey);
    }

    public I18nString getLocalizedStringWithoutFallbackToDefault(MessageSource msg, String baseKey) {
        return UnityPropertiesHelper.getLocalizedStringWithoutFallbackToDefault(this, msg, baseKey);
    }

    static I18nString getLocalizedString(PropertiesHelper helper, MessageSource msg, String baseKey) {
        I18nString ret = new I18nString();
        Map supportedLocales = msg.getSupportedLocales();
        String defaultVal = helper.getValue(baseKey);
        if (defaultVal != null) {
            ret.setDefaultValue(defaultVal);
        }
        for (Map.Entry locale : supportedLocales.entrySet()) {
            String v = helper.getLocalizedValue(baseKey, (Locale)locale.getValue());
            if (v == null || v.equals(defaultVal)) continue;
            ret.addValue((String)locale.getKey(), v);
        }
        return ret;
    }

    static I18nString getLocalizedStringWithoutFallbackToDefault(UnityPropertiesHelper helper, MessageSource msg, String baseKey) {
        I18nString ret = new I18nString();
        Map supportedLocales = msg.getSupportedLocales();
        String defaultVal = helper.getValue(baseKey);
        for (Map.Entry locale : supportedLocales.entrySet()) {
            String v = helper.getLocalizedValueWithOutFallbackToDefault(baseKey, (Locale)locale.getValue());
            if (v == null) continue;
            ret.addValue((String)locale.getKey(), v);
        }
        if ((ret.getValueRaw(msg.getDefaultLocaleCode()) == null || ret.getValueRaw(msg.getDefaultLocaleCode()).isEmpty()) && defaultVal != null) {
            ret.addValue(msg.getDefaultLocaleCode(), defaultVal);
        }
        return ret;
    }

    public String getLocalizedValueWithOutFallbackToDefault(String key, Locale locale) {
        Object fullLocale;
        boolean hasCountry = !locale.getCountry().equals("");
        boolean hasLang = !locale.getLanguage().equals("");
        String keyPfx = key + ".";
        if (hasCountry && hasLang && this.isSet(keyPfx + (String)(fullLocale = locale.getLanguage() + "_" + locale.getCountry()))) {
            return this.getValue(keyPfx + (String)fullLocale);
        }
        if (hasLang && this.isSet(keyPfx + (String)(fullLocale = locale.getLanguage()))) {
            return this.getValue(keyPfx + (String)fullLocale);
        }
        return null;
    }

    public String getAsString() {
        StringWriter writer = new StringWriter();
        try {
            this.properties.store(writer, "");
        }
        catch (IOException e) {
            throw new InternalException("Can not save properties to string");
        }
        return writer.getBuffer().toString();
    }

    public static Properties parse(String properties) {
        Properties raw = new Properties();
        try {
            raw.load(new StringReader(properties));
        }
        catch (IOException e) {
            throw new InternalException("Can not parse proeprties", (Throwable)e);
        }
        return raw;
    }
}

