/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.idp.statistic;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;

public class GroupedIdpStatistic {
    public final String idpId;
    public final String idpName;
    public final String clientId;
    public final String clientName;
    public final List<SigInStatistic> sigInStats;

    @JsonCreator
    public GroupedIdpStatistic(@JsonProperty(value="idpId") String idpId, @JsonProperty(value="idpName") String idpName, @JsonProperty(value="clientId") String clientId, @JsonProperty(value="clientName") String clientName, @JsonProperty(value="sigInStats") List<SigInStatistic> sigInStats) {
        this.idpId = idpId;
        this.idpName = idpName;
        this.clientId = clientId;
        this.clientName = clientName;
        this.sigInStats = ImmutableList.copyOf(sigInStats);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.clientName, this.idpId, this.idpName, this.sigInStats);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GroupedIdpStatistic other = (GroupedIdpStatistic)obj;
        return Objects.equals(this.clientId, other.clientId) && Objects.equals(this.clientName, other.clientName) && Objects.equals(this.idpId, other.idpId) && Objects.equals(this.idpName, other.idpName) && Objects.equals(this.sigInStats, other.sigInStats);
    }

    public static class SigInStatistic {
        @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss'Z'", timezone="UTC")
        public final LocalDateTime periodStart;
        @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss'Z'", timezone="UTC")
        public final LocalDateTime periodEnd;
        public final long totatCount;
        public final long successfullCount;
        public final long failedCount;

        @JsonCreator
        public SigInStatistic(@JsonProperty(value="periodStart") LocalDateTime periodStart, @JsonProperty(value="periodEnd") LocalDateTime periodEnd, @JsonProperty(value="totatCount") long totatCount, @JsonProperty(value="successfullCount") long successfullCount, @JsonProperty(value="failedCount") long failedCount) {
            this.periodStart = periodStart;
            this.periodEnd = periodEnd;
            this.totatCount = totatCount;
            this.successfullCount = successfullCount;
            this.failedCount = failedCount;
        }

        public int hashCode() {
            return Objects.hash(this.failedCount, this.periodEnd, this.periodStart, this.successfullCount, this.totatCount);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SigInStatistic other = (SigInStatistic)obj;
            return this.failedCount == other.failedCount && Objects.equals(this.periodEnd, other.periodEnd) && Objects.equals(this.periodStart, other.periodStart) && this.successfullCount == other.successfullCount && this.totatCount == other.totatCount;
        }
    }
}

