/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.translation.form;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pl.edu.icm.unity.base.attribute.Attribute;
import pl.edu.icm.unity.base.entity.EntityState;
import pl.edu.icm.unity.base.i18n.I18nMessage;
import pl.edu.icm.unity.base.identity.IdentityParam;
import pl.edu.icm.unity.engine.api.translation.form.AutomaticInvitationProcessingParam;
import pl.edu.icm.unity.engine.api.translation.form.GroupParam;
import pl.edu.icm.unity.engine.api.translation.in.EntityChange;

public class TranslatedRegistrationRequest {
    private AutomaticRequestAction autoAction = AutomaticRequestAction.none;
    private Map<String, IdentityParam> identities = new HashMap<String, IdentityParam>();
    private Map<String, Attribute> attributes = new HashMap<String, Attribute>();
    private Map<String, GroupParam> groups = new HashMap<String, GroupParam>();
    private Map<String, Set<String>> attributeClasses = new HashMap<String, Set<String>>();
    private EntityChange entityChange;
    private EntityState entityState = EntityState.valid;
    private String credentialRequirement;
    private String redirectURL = null;
    private I18nMessage postSubmitMessage;
    private List<AutomaticInvitationProcessingParam> invitationProcessingParams = new ArrayList<AutomaticInvitationProcessingParam>();
    private Boolean mfaPreferenceStatus;

    public TranslatedRegistrationRequest(String credentialRequirement) {
        this.credentialRequirement = credentialRequirement;
    }

    public TranslatedRegistrationRequest() {
    }

    public void addIdentity(IdentityParam identity) {
        this.identities.put(identity.getTypeId() + "_" + identity.getValue(), identity);
    }

    public void removeIdentity(IdentityParam identity) {
        this.identities.remove(identity.getTypeId() + "_" + identity.getValue());
    }

    public void addAttribute(Attribute attribute) {
        this.attributes.put(attribute.getGroupPath() + "//" + attribute.getName(), attribute);
    }

    public void removeAttribute(Attribute attribute) {
        this.attributes.remove(attribute.getGroupPath() + "//" + attribute.getName());
    }

    public void addMembership(GroupParam group) {
        this.groups.put(group.getGroup(), group);
    }

    public void removeMembership(String group) {
        this.groups.remove(group);
    }

    public void addAttributeClass(String group, String ac) {
        Set<String> acs = this.attributeClasses.get(group);
        if (acs == null) {
            acs = new HashSet<String>();
            this.attributeClasses.put(group, acs);
        }
        acs.add(ac);
    }

    public void setAutoAction(AutomaticRequestAction autoAction) {
        this.autoAction = autoAction;
    }

    public void setEntityChange(EntityChange entityChange) {
        this.entityChange = entityChange;
    }

    public void setEntityState(EntityState entityState) {
        this.entityState = entityState;
    }

    public AutomaticRequestAction getAutoAction() {
        return this.autoAction;
    }

    public Collection<IdentityParam> getIdentities() {
        return this.identities.values();
    }

    public Collection<Attribute> getAttributes() {
        return this.attributes.values();
    }

    public Collection<GroupParam> getGroups() {
        return this.groups.values();
    }

    public EntityChange getEntityChange() {
        return this.entityChange;
    }

    public EntityState getEntityState() {
        return this.entityState;
    }

    public String getCredentialRequirement() {
        return this.credentialRequirement;
    }

    public String getRedirectURL() {
        return this.redirectURL;
    }

    public void setRedirectURL(String redirectURL) {
        this.redirectURL = redirectURL;
    }

    public void setCredentialRequirement(String credentialRequirement) {
        this.credentialRequirement = credentialRequirement;
    }

    public Map<String, Set<String>> getAttributeClasses() {
        return this.attributeClasses;
    }

    public I18nMessage getPostSubmitMessage() {
        return this.postSubmitMessage;
    }

    public void setPostSubmitMessage(I18nMessage message) {
        this.postSubmitMessage = message;
    }

    public List<AutomaticInvitationProcessingParam> getInvitationProcessingParams() {
        return this.invitationProcessingParams;
    }

    public void addInvitationProcessingParam(AutomaticInvitationProcessingParam invitationProcessing) {
        this.invitationProcessingParams.add(invitationProcessing);
    }

    public Boolean getMfaPreferenceStatus() {
        return this.mfaPreferenceStatus;
    }

    public void setMfaPreferenceStatus(boolean mfaPreferenceStatus) {
        this.mfaPreferenceStatus = mfaPreferenceStatus;
    }

    public static enum AutomaticRequestAction {
        none,
        drop,
        reject,
        accept;

    }
}

