/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.utils;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import pl.edu.icm.unity.engine.api.config.UnityServerConfiguration;

@Component
public class ExecutorsService {
    private final ScheduledExecutorService scheduledExecutor;
    private final ExecutorService workStealingExecutor;

    @Autowired
    public ExecutorsService(UnityServerConfiguration cfg) {
        this.scheduledExecutor = Executors.newScheduledThreadPool(cfg.getIntValue("threadPoolSize"));
        this.workStealingExecutor = Executors.newWorkStealingPool(cfg.getIntValue("concurrentThreadPoolSize"));
    }

    public ScheduledExecutorService getScheduledService() {
        return this.scheduledExecutor;
    }

    public ExecutorService getExecutionService() {
        return this.workStealingExecutor;
    }
}

