/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.stdext.attr;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Optional;
import org.springframework.stereotype.Component;
import pl.edu.icm.unity.Constants;
import pl.edu.icm.unity.JsonUtil;
import pl.edu.icm.unity.engine.api.attributes.AbstractAttributeValueSyntaxFactory;
import pl.edu.icm.unity.engine.api.attributes.AttributeValueSyntax;
import pl.edu.icm.unity.exceptions.IllegalAttributeValueException;
import pl.edu.icm.unity.stdext.utils.MobileNumberUtils;
import pl.edu.icm.unity.types.basic.VerifiableMobileNumber;
import pl.edu.icm.unity.types.confirmation.MobileNumberConfirmationConfiguration;

public class VerifiableMobileNumberAttributeSyntax
implements AttributeValueSyntax<VerifiableMobileNumber> {
    public static final String ID = "verifiableMobileNumber";
    private MobileNumberConfirmationConfiguration mobileNumberConfirmationConfiguration;

    public String getValueSyntaxId() {
        return ID;
    }

    public boolean areEqual(VerifiableMobileNumber value, Object another) {
        return value.equals(another);
    }

    public int hashCode(Object value) {
        return value.hashCode();
    }

    public void validate(VerifiableMobileNumber value) throws IllegalAttributeValueException {
        if (value == null) {
            throw new IllegalAttributeValueException("null value is illegal");
        }
        String error = MobileNumberUtils.validate(value.getValue());
        if (error != null) {
            throw new IllegalAttributeValueException(value.getValue() + ": " + error);
        }
    }

    public JsonNode getSerializedConfiguration() {
        ObjectNode main = Constants.MAPPER.createObjectNode();
        if (this.getMobileNumberConfirmationConfiguration().isPresent()) {
            main.set("mobileConfirmationConfiguration", (JsonNode)this.getMobileNumberConfirmationConfiguration().get().toJson());
        }
        return main;
    }

    public void setSerializedConfiguration(JsonNode json) {
        if (JsonUtil.notNull((JsonNode)json, (String)"mobileConfirmationConfiguration")) {
            this.setMobileNumberConfirmationConfiguration(new MobileNumberConfirmationConfiguration((ObjectNode)json.get("mobileConfirmationConfiguration")));
        }
    }

    public boolean isEmailVerifiable() {
        return false;
    }

    public boolean isUserVerifiable() {
        return true;
    }

    public VerifiableMobileNumber convertFromString(String stringRepresentation) {
        return new VerifiableMobileNumber((JsonNode)JsonUtil.parse((String)stringRepresentation));
    }

    public String convertToString(VerifiableMobileNumber value) {
        return JsonUtil.serialize((JsonNode)value.toJson());
    }

    public String serializeSimple(VerifiableMobileNumber value) {
        return value.getValue();
    }

    public VerifiableMobileNumber deserializeSimple(String value) throws IllegalAttributeValueException {
        VerifiableMobileNumber ret = MobileNumberUtils.convertFromString(value);
        this.validate(ret);
        return ret;
    }

    public void setMobileNumberConfirmationConfiguration(MobileNumberConfirmationConfiguration confirmationConfiguration) {
        this.mobileNumberConfirmationConfiguration = confirmationConfiguration;
    }

    public Optional<MobileNumberConfirmationConfiguration> getMobileNumberConfirmationConfiguration() {
        return Optional.ofNullable(this.mobileNumberConfirmationConfiguration);
    }

    @Component
    public static class Factory
    extends AbstractAttributeValueSyntaxFactory<VerifiableMobileNumber> {
        public Factory() {
            super(VerifiableMobileNumberAttributeSyntax.ID, VerifiableMobileNumberAttributeSyntax::new);
        }
    }
}

