/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.stdext.credential.pass;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import pl.edu.icm.unity.Constants;
import pl.edu.icm.unity.JsonUtil;
import pl.edu.icm.unity.engine.api.authn.local.CredentialHelper;
import pl.edu.icm.unity.engine.api.authn.local.LocalCredentialVerificator;
import pl.edu.icm.unity.engine.api.identity.IdentityResolver;
import pl.edu.icm.unity.engine.api.notification.NotificationProducer;
import pl.edu.icm.unity.exceptions.IllegalIdentityValueException;
import pl.edu.icm.unity.exceptions.TooManyAttempts;
import pl.edu.icm.unity.exceptions.WrongArgumentException;
import pl.edu.icm.unity.stdext.credential.CredentialResetBase;
import pl.edu.icm.unity.stdext.credential.pass.PasswordCredentialDBState;
import pl.edu.icm.unity.stdext.credential.pass.PasswordCredentialResetSettings;
import pl.edu.icm.unity.stdext.credential.pass.PasswordEngine;
import pl.edu.icm.unity.stdext.credential.pass.PasswordInfo;
import pl.edu.icm.unity.stdext.credential.pass.PasswordVerificator;
import pl.edu.icm.unity.types.basic.IdentityTaV;

public class PasswordCredentialResetImpl
extends CredentialResetBase {
    private PasswordCredentialResetSettings settings;
    private PasswordEngine passwordEngine;
    private int answerAttempts = 0;

    public PasswordCredentialResetImpl(NotificationProducer notificationProducer, IdentityResolver identityResolver, LocalCredentialVerificator localVerificator, CredentialHelper credentialHelper, String credentialId, ObjectNode completeCredentialConfiguration, PasswordCredentialResetSettings settings, PasswordEngine passwordEngine) {
        super(notificationProducer, identityResolver, localVerificator, credentialHelper, credentialId, completeCredentialConfiguration);
        this.settings = settings;
        this.passwordEngine = passwordEngine;
    }

    @Override
    protected String getCredentialSettings() {
        ObjectNode node = Constants.MAPPER.createObjectNode();
        this.settings.serializeTo(node);
        return JsonUtil.toJsonString((Object)node);
    }

    @Override
    protected int getCodeLength() {
        return this.settings.getCodeLength();
    }

    @Override
    public String getSecurityQuestion() {
        if (!this.checkSubject()) {
            return this.getFakeQuestion();
        }
        PasswordCredentialDBState credState = PasswordCredentialDBState.fromJson(this.resolved.getCredentialValue());
        String q = credState.getSecurityQuestion();
        if (q == null) {
            return this.getFakeQuestion();
        }
        return q;
    }

    private String getFakeQuestion() {
        List<String> questions = this.settings.getQuestions();
        int hash = this.requestedSubject.getValue().hashCode();
        int num = (hash < 0 ? -hash : hash) % questions.size();
        return questions.get(num);
    }

    @Override
    public void verifyStaticData(String answer) throws WrongArgumentException, IllegalIdentityValueException, TooManyAttempts {
        if (!this.checkSubject()) {
            throw new IllegalIdentityValueException("Identity was not resolved.");
        }
        if (this.answerAttempts >= 2) {
            throw new TooManyAttempts();
        }
        ++this.answerAttempts;
        PasswordCredentialDBState credState = PasswordCredentialDBState.fromJson(this.resolved.getCredentialValue());
        PasswordInfo storedAnswer = credState.getAnswer();
        String question = credState.getSecurityQuestion();
        if (storedAnswer == null || question == null) {
            throw new IllegalIdentityValueException("Identity has no question set.");
        }
        if (!this.passwordEngine.verify(storedAnswer, answer)) {
            throw new WrongArgumentException("The answer is incorrect");
        }
    }

    public void setSubject(IdentityTaV subject) {
        super.setSubject(subject, PasswordVerificator.IDENTITY_TYPES);
    }
}

