/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.stdext.credential.pass;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import pl.edu.icm.unity.stdext.credential.pass.PasswordHashMethod;

public class PasswordInfo {
    private PasswordHashMethod method;
    private Map<String, Object> methodParams;
    private byte[] hash;
    private byte[] salt;
    private Date time;

    public PasswordInfo(PasswordHashMethod method, byte[] hash, byte[] salt, Map<String, Object> methodParams) {
        this(method, hash, salt, methodParams, System.currentTimeMillis());
    }

    public PasswordInfo(PasswordHashMethod method, byte[] hash, byte[] salt, Map<String, Object> methodParams, long time) {
        this.method = method;
        this.methodParams = new HashMap<String, Object>(methodParams);
        this.hash = Arrays.copyOf(hash, hash.length);
        this.salt = salt;
        this.time = new Date(time);
    }

    protected PasswordInfo() {
    }

    public byte[] getHash() {
        return Arrays.copyOf(this.hash, this.hash.length);
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public Date getTime() {
        return this.time;
    }

    public PasswordHashMethod getMethod() {
        return this.method;
    }

    public Map<String, Object> getMethodParams() {
        return new HashMap<String, Object>(this.methodParams);
    }
}

