/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.stdext.credential.sms;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashMap;
import java.util.Locale;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import pl.edu.icm.unity.JsonUtil;
import pl.edu.icm.unity.base.utils.Log;
import pl.edu.icm.unity.engine.api.authn.AuthenticatedEntity;
import pl.edu.icm.unity.engine.api.authn.AuthenticationResult;
import pl.edu.icm.unity.engine.api.authn.EntityWithCredential;
import pl.edu.icm.unity.engine.api.authn.SandboxAuthnContext;
import pl.edu.icm.unity.engine.api.authn.local.AbstractLocalCredentialVerificatorFactory;
import pl.edu.icm.unity.engine.api.authn.local.AbstractLocalVerificator;
import pl.edu.icm.unity.engine.api.authn.local.CredentialHelper;
import pl.edu.icm.unity.engine.api.authn.local.LocalCredentialVerificator;
import pl.edu.icm.unity.engine.api.authn.local.LocalSandboxAuthnContext;
import pl.edu.icm.unity.engine.api.authn.remote.SandboxAuthnResultCallback;
import pl.edu.icm.unity.engine.api.confirmation.SMSCode;
import pl.edu.icm.unity.engine.api.msg.LocaleHelper;
import pl.edu.icm.unity.engine.api.notification.NotificationProducer;
import pl.edu.icm.unity.engine.api.utils.CodeGenerator;
import pl.edu.icm.unity.engine.api.utils.PrototypeComponent;
import pl.edu.icm.unity.exceptions.EngineException;
import pl.edu.icm.unity.exceptions.IllegalCredentialException;
import pl.edu.icm.unity.exceptions.InternalException;
import pl.edu.icm.unity.stdext.credential.sms.AuthnSMSCounter;
import pl.edu.icm.unity.stdext.credential.sms.SMSCredential;
import pl.edu.icm.unity.stdext.credential.sms.SMSCredentialDBState;
import pl.edu.icm.unity.stdext.credential.sms.SMSCredentialExtraInfo;
import pl.edu.icm.unity.stdext.credential.sms.SMSCredentialResetImpl;
import pl.edu.icm.unity.stdext.credential.sms.SMSExchange;
import pl.edu.icm.unity.types.authn.CredentialPublicInformation;
import pl.edu.icm.unity.types.authn.LocalCredentialState;
import pl.edu.icm.unity.types.basic.EntityParam;

@PrototypeComponent
public class SMSVerificator
extends AbstractLocalVerificator
implements SMSExchange {
    private static final Logger log = Log.getLogger((String)"unity.server", SMSVerificator.class);
    public static final String NAME = "sms";
    public static final String DESC = "Verifies sms";
    public static final String[] IDENTITY_TYPES = new String[]{"userName", "email"};
    private SMSCredential credential = new SMSCredential();
    private NotificationProducer notificationProducer;
    private CredentialHelper credentialHelper;
    private AuthnSMSCounter smslimitCache;

    @Autowired
    public SMSVerificator(NotificationProducer notificationProducer, CredentialHelper credentialHelper, AuthnSMSCounter smslimitCache) {
        super(NAME, DESC, "sms exchange", true);
        this.notificationProducer = notificationProducer;
        this.credentialHelper = credentialHelper;
        this.smslimitCache = smslimitCache;
    }

    public String prepareCredential(String rawCredential, String currentCredential, boolean verifyNew) throws IllegalCredentialException, InternalException {
        return SMSCredentialDBState.toJson(this.credential, rawCredential, System.currentTimeMillis());
    }

    public CredentialPublicInformation checkCredentialState(String currentCredential) throws InternalException {
        SMSCredentialDBState parsedCred = SMSCredentialDBState.fromJson(currentCredential);
        if (parsedCred.getValue() == null || parsedCred.getValue().isEmpty()) {
            return new CredentialPublicInformation(LocalCredentialState.notSet, "");
        }
        SMSCredentialExtraInfo pei = new SMSCredentialExtraInfo(parsedCred.getTime(), parsedCred.getValue());
        String extraInfo = pei.toJson();
        return new CredentialPublicInformation(LocalCredentialState.correct, extraInfo);
    }

    public String invalidate(String currentCredential) {
        throw new IllegalStateException("This credential doesn't support invalidation");
    }

    public String getSerializedConfiguration() throws InternalException {
        return JsonUtil.serialize((JsonNode)this.credential.getSerializedConfiguration());
    }

    public void setSerializedConfiguration(String json) throws InternalException {
        this.credential.setSerializedConfiguration(JsonUtil.parse((String)json));
    }

    @Override
    public SMSCode sendCode(String username, boolean force) throws EngineException {
        if (this.isAuthSMSLimitExceeded(username)) {
            if (force) {
                log.debug("Forcing sending authn sms code to the user " + username + ", but authn sms limit is exceeded");
            } else {
                log.debug("Authn sms limit to the user " + username + " is exceeded, skipping send authn sms");
                return null;
            }
        }
        this.smslimitCache.incValue(username);
        EntityWithCredential resolved = null;
        try {
            resolved = this.identityResolver.resolveIdentity(username, IDENTITY_TYPES, this.credentialName);
        }
        catch (Exception e) {
            log.debug("The user for sms authN can not be found: " + username, (Throwable)e);
            return null;
        }
        String credentialValue = resolved.getCredentialValue();
        if (credentialValue == null) {
            log.debug("The user {} does not have {} credential defined, skipping sending authentication code", (Object)username, (Object)this.credentialName);
            return null;
        }
        SMSCredentialDBState credState = SMSCredentialDBState.fromJson(credentialValue);
        String code = CodeGenerator.generateNumberCode((int)this.credential.getCodeLength());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("code", code);
        params.put("user", username);
        Locale currentLocale = LocaleHelper.getLocale(null);
        String locale = currentLocale == null ? null : currentLocale.toString();
        this.notificationProducer.sendNotification(credState.getValue(), this.credential.getMessageTemplate(), params, locale);
        return new SMSCode(System.currentTimeMillis() + (long)(this.credential.getValidityTime() * 60 * 1000), code, credState.getValue());
    }

    @Override
    public AuthenticationResult verifyCode(SMSCode sentCode, String codeFromUser, String username, SandboxAuthnResultCallback sandboxCallback) {
        AuthenticationResult authenticationResult = this.verifyCodeInternal(sentCode, codeFromUser, username);
        if (sandboxCallback != null) {
            sandboxCallback.sandboxedAuthenticationDone((SandboxAuthnContext)new LocalSandboxAuthnContext(authenticationResult));
        }
        return authenticationResult;
    }

    private AuthenticationResult verifyCodeInternal(SMSCode sentCode, String codeFromUser, String username) {
        EntityWithCredential resolved;
        if (sentCode == null) {
            return new AuthenticationResult(AuthenticationResult.Status.deny, null);
        }
        try {
            resolved = this.identityResolver.resolveIdentity(username, IDENTITY_TYPES, this.credentialName);
        }
        catch (Exception e) {
            log.debug("The user for sms authN can not be found: " + username, (Throwable)e);
            return new AuthenticationResult(AuthenticationResult.Status.deny, null);
        }
        if (System.currentTimeMillis() > sentCode.getValidTo()) {
            log.debug("SMS code provided by " + username + " is invalid");
            return new AuthenticationResult(AuthenticationResult.Status.deny, null);
        }
        if (codeFromUser == null || !sentCode.getValue().equals(codeFromUser)) {
            log.debug("SMS code provided by " + username + " is incorrect");
            return new AuthenticationResult(AuthenticationResult.Status.deny, null);
        }
        AuthenticatedEntity ae = new AuthenticatedEntity(Long.valueOf(resolved.getEntityId()), username, null);
        this.smslimitCache.reset(username);
        return new AuthenticationResult(AuthenticationResult.Status.success, ae);
    }

    @Override
    public SMSCredentialResetImpl getSMSCredentialResetBackend() {
        return new SMSCredentialResetImpl(this.notificationProducer, this.identityResolver, (LocalCredentialVerificator)this, this.credentialHelper, this.credentialName, this.credential.getSerializedConfiguration(), this.credential.getRecoverySettings());
    }

    @Override
    public boolean isAuthSMSLimitExceeded(String username) {
        return this.smslimitCache.getValue(username) >= this.credential.getAuthnSMSLimit();
    }

    public boolean isCredentialSet(EntityParam entity) throws EngineException {
        return this.credentialHelper.isCredentialSet(entity, this.credentialName);
    }

    public boolean isCredentialDefinitionChagneOutdatingCredentials(String newCredentialDefinition) {
        return false;
    }

    @Component
    public static class Factory
    extends AbstractLocalCredentialVerificatorFactory {
        @Autowired
        public Factory(ObjectFactory<SMSVerificator> factory) {
            super(SMSVerificator.NAME, SMSVerificator.DESC, false, factory);
        }
    }
}

