/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.stdext.identity;

import java.util.UUID;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;
import pl.edu.icm.unity.MessageSource;
import pl.edu.icm.unity.base.utils.Escaper;
import pl.edu.icm.unity.base.utils.Log;
import pl.edu.icm.unity.stdext.identity.AbstractIdentityTypeProvider;
import pl.edu.icm.unity.types.basic.Identity;
import pl.edu.icm.unity.types.basic.IdentityParam;

@Component
public class TargetedPersistentIdentity
extends AbstractIdentityTypeProvider {
    static final Logger log = Log.getLogger((String)"unity.server", TargetedPersistentIdentity.class);
    public static final String ID = "targetedPersistent";

    public String getId() {
        return ID;
    }

    public String getDefaultDescriptionKey() {
        return "TargetedPersistentIdentity.description";
    }

    public void validate(String value) {
    }

    public String toPrettyStringNoPrefix(IdentityParam from) {
        return from.getValue();
    }

    public boolean isDynamic() {
        return true;
    }

    public Identity createNewIdentity(String realm, String target, long entityId) {
        if (realm == null || target == null) {
            throw new IllegalArgumentException("Targeted persistent identity can be created only when target is defined");
        }
        String inDbValue = UUID.randomUUID().toString();
        String cmpVal = Escaper.encode((String[])new String[]{realm, target, inDbValue});
        Identity ret = new Identity(ID, inDbValue, entityId, cmpVal);
        ret.setRealm(realm);
        ret.setTarget(target);
        return ret;
    }

    public boolean isTargeted() {
        return true;
    }

    public String getComparableValue(String from, String realm, String target) {
        return Escaper.encode((String[])new String[]{realm, target, from});
    }

    public boolean isExpired(Identity representation) {
        return false;
    }

    public String getHumanFriendlyDescription(MessageSource msg) {
        return msg.getMessage("TargetedPersistentIdentity.description", new Object[0]);
    }

    @Override
    public String toHumanFriendlyString(MessageSource msg, IdentityParam from) {
        return msg.getMessage("TargetedPersistentIdentity.fullyAnonymous", new Object[0]);
    }

    public boolean isEmailVerifiable() {
        return false;
    }

    public String getHumanFriendlyName(MessageSource msg) {
        return msg.getMessage("TargetedPersistentIdentity.name", new Object[0]);
    }
}

