/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.stdext.utils;

import java.util.List;
import org.apache.commons.validator.routines.EmailValidator;
import pl.edu.icm.unity.stdext.utils.ConfirmationUtils;
import pl.edu.icm.unity.types.basic.VerifiableElementBase;
import pl.edu.icm.unity.types.basic.VerifiableEmail;

public class EmailUtils {
    private static final int MAX_LENGTH = 80;

    public static String validate(String value) {
        if (value == null) {
            return "null value is illegal";
        }
        if (value.length() > 80) {
            return "Value length (" + value.length() + ") is too big, must be not greater than " + 80;
        }
        if (!EmailValidator.getInstance().isValid(value)) {
            return "Value is not a valid email address";
        }
        if (value.startsWith("+")) {
            return "Value must not start with '+', which is used to separate email tags";
        }
        return null;
    }

    public static VerifiableEmail convertFromString(String stringRepresentationRaw) {
        VerifiableElementBase verifiableBase = ConfirmationUtils.convertFromString(stringRepresentationRaw);
        VerifiableEmail ret = new VerifiableEmail(verifiableBase.getValue(), verifiableBase.getConfirmationInfo());
        List tags = VerifiableEmail.extractTags((String)verifiableBase.getValue());
        ret.setTags(tags);
        return ret;
    }
}

