/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.stdext.attr;

import java.util.Base64;
import org.springframework.stereotype.Component;
import pl.edu.icm.unity.attr.ImageType;
import pl.edu.icm.unity.attr.UnityImage;
import pl.edu.icm.unity.engine.api.attributes.AbstractAttributeValueSyntaxFactory;
import pl.edu.icm.unity.exceptions.IllegalAttributeValueException;
import pl.edu.icm.unity.stdext.attr.BaseImageAttributeSyntax;
import pl.edu.icm.unity.stdext.utils.ImageValidatorUtil;

public class JpegImageAttributeSyntax
extends BaseImageAttributeSyntax<UnityImage> {
    public static final String ID = "jpegImage";

    public String getValueSyntaxId() {
        return ID;
    }

    public void validate(UnityImage value) throws IllegalAttributeValueException {
        ImageValidatorUtil.validate(this.getConfig(), value);
    }

    public UnityImage convertFromString(String stringRepresentation) {
        byte[] rawData = Base64.getDecoder().decode(stringRepresentation);
        return new UnityImage(rawData, ImageType.JPG);
    }

    public String convertToString(UnityImage value) {
        return Base64.getEncoder().encodeToString(value.getImage());
    }

    @Component
    public static class Factory
    extends AbstractAttributeValueSyntaxFactory<UnityImage> {
        public Factory() {
            super(JpegImageAttributeSyntax.ID, JpegImageAttributeSyntax::new);
        }
    }
}

