/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.stdext.credential.pass;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import pl.edu.icm.unity.Constants;
import pl.edu.icm.unity.exceptions.IllegalCredentialException;
import pl.edu.icm.unity.exceptions.InternalException;

public class PasswordToken {
    private String password;
    private String existingPassword = null;
    private int question = -1;
    private String answer = null;

    private PasswordToken() {
    }

    public PasswordToken(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getExistingPassword() {
        return this.existingPassword;
    }

    public void setExistingPassword(String existingPassword) {
        this.existingPassword = existingPassword;
    }

    public int getQuestion() {
        return this.question;
    }

    public void setQuestion(int question) {
        this.question = question;
    }

    public String getAnswer() {
        return this.answer;
    }

    public void setAnswer(String answer) {
        this.answer = answer;
    }

    public JsonNode toJsonNode() {
        ObjectNode root = Constants.MAPPER.createObjectNode();
        if (this.existingPassword != null) {
            root.put("existingPassword", this.existingPassword);
        }
        root.put("password", this.password);
        if (this.answer != null) {
            root.put("answer", this.answer);
            root.put("question", this.question);
        }
        return root;
    }

    public String toJson() {
        try {
            JsonNode root = this.toJsonNode();
            return Constants.MAPPER.writeValueAsString((Object)root);
        }
        catch (JsonProcessingException e) {
            throw new InternalException("Can't serialize password credential to JSON", (Throwable)e);
        }
    }

    public static PasswordToken loadFromJson(String json) throws IllegalCredentialException {
        try {
            PasswordToken ret = new PasswordToken();
            ObjectNode inputNode = (ObjectNode)Constants.MAPPER.readTree(json);
            ret.password = inputNode.get("password").asText();
            if (inputNode.has("existingPassword")) {
                ret.existingPassword = inputNode.get("existingPassword").asText();
            }
            if (inputNode.has("answer")) {
                ret.answer = inputNode.get("answer").asText();
            }
            if (inputNode.has("question")) {
                ret.question = inputNode.get("question").asInt();
            }
            return ret;
        }
        catch (Exception e) {
            throw new IllegalCredentialException("The supplied credential definition has invalid syntax", (Throwable)e);
        }
    }
}

