/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.stdext.credential.pass;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import com.nulabinc.zxcvbn.Strength;
import com.nulabinc.zxcvbn.Zxcvbn;
import edu.vt.middleware.password.AlphabeticalSequenceRule;
import edu.vt.middleware.password.CharacterCharacteristicsRule;
import edu.vt.middleware.password.CharacterRule;
import edu.vt.middleware.password.DigitCharacterRule;
import edu.vt.middleware.password.LengthRule;
import edu.vt.middleware.password.LowercaseCharacterRule;
import edu.vt.middleware.password.NonAlphanumericCharacterRule;
import edu.vt.middleware.password.NumericalSequenceRule;
import edu.vt.middleware.password.Password;
import edu.vt.middleware.password.PasswordData;
import edu.vt.middleware.password.PasswordValidator;
import edu.vt.middleware.password.QwertySequenceRule;
import edu.vt.middleware.password.RepeatCharacterRegexRule;
import edu.vt.middleware.password.Rule;
import edu.vt.middleware.password.RuleResult;
import edu.vt.middleware.password.UppercaseCharacterRule;
import java.util.ArrayList;
import java.util.Date;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ForkJoinPool;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import pl.edu.icm.unity.Constants;
import pl.edu.icm.unity.JsonUtil;
import pl.edu.icm.unity.base.utils.Log;
import pl.edu.icm.unity.engine.api.authn.AuthenticatedEntity;
import pl.edu.icm.unity.engine.api.authn.AuthenticationException;
import pl.edu.icm.unity.engine.api.authn.AuthenticationResult;
import pl.edu.icm.unity.engine.api.authn.CredentialReset;
import pl.edu.icm.unity.engine.api.authn.EntityWithCredential;
import pl.edu.icm.unity.engine.api.authn.SandboxAuthnContext;
import pl.edu.icm.unity.engine.api.authn.local.AbstractLocalCredentialVerificatorFactory;
import pl.edu.icm.unity.engine.api.authn.local.AbstractLocalVerificator;
import pl.edu.icm.unity.engine.api.authn.local.CredentialHelper;
import pl.edu.icm.unity.engine.api.authn.local.LocalCredentialVerificator;
import pl.edu.icm.unity.engine.api.authn.local.LocalSandboxAuthnContext;
import pl.edu.icm.unity.engine.api.authn.remote.SandboxAuthnResultCallback;
import pl.edu.icm.unity.engine.api.notification.NotificationProducer;
import pl.edu.icm.unity.engine.api.utils.PrototypeComponent;
import pl.edu.icm.unity.exceptions.CredentialRecentlyUsedException;
import pl.edu.icm.unity.exceptions.EngineException;
import pl.edu.icm.unity.exceptions.IllegalCredentialException;
import pl.edu.icm.unity.exceptions.InternalException;
import pl.edu.icm.unity.stdext.credential.pass.PasswordCredential;
import pl.edu.icm.unity.stdext.credential.pass.PasswordCredentialDBState;
import pl.edu.icm.unity.stdext.credential.pass.PasswordCredentialResetImpl;
import pl.edu.icm.unity.stdext.credential.pass.PasswordEncodingPoolProvider;
import pl.edu.icm.unity.stdext.credential.pass.PasswordEngine;
import pl.edu.icm.unity.stdext.credential.pass.PasswordExchange;
import pl.edu.icm.unity.stdext.credential.pass.PasswordExtraInfo;
import pl.edu.icm.unity.stdext.credential.pass.PasswordInfo;
import pl.edu.icm.unity.stdext.credential.pass.PasswordToken;
import pl.edu.icm.unity.types.authn.CredentialPublicInformation;
import pl.edu.icm.unity.types.authn.LocalCredentialState;
import pl.edu.icm.unity.types.basic.EntityParam;

@PrototypeComponent
public class PasswordVerificator
extends AbstractLocalVerificator
implements PasswordExchange {
    private static final Logger log = Log.getLogger((String)"unity.server", PasswordVerificator.class);
    public static final String NAME = "password";
    public static final String DESC = "Verifies passwords";
    public static final String[] IDENTITY_TYPES = new String[]{"userName", "email"};
    private NotificationProducer notificationProducer;
    private CredentialHelper credentialHelper;
    private PasswordEngine passwordEngine;
    private PasswordCredential credential = new PasswordCredential();

    @Autowired
    public PasswordVerificator(NotificationProducer notificationProducer, CredentialHelper credentialHelper, Optional<PasswordEncodingPoolProvider> threadPoolProvider) {
        super(NAME, DESC, "password exchange", true);
        this.notificationProducer = notificationProducer;
        this.credentialHelper = credentialHelper;
        this.passwordEngine = new PasswordEngine(threadPoolProvider.map(pp -> pp.pool).orElse(ForkJoinPool.commonPool()));
    }

    public String getSerializedConfiguration() throws InternalException {
        return JsonUtil.serialize((JsonNode)this.credential.getSerializedConfiguration());
    }

    public void setSerializedConfiguration(String json) throws InternalException {
        this.credential.setSerializedConfiguration(JsonUtil.parse((String)json));
    }

    public String prepareCredential(String rawCredential, String currentCredential, boolean verify) throws IllegalCredentialException, InternalException {
        Deque<PasswordInfo> currentPasswords = PasswordCredentialDBState.fromJson(currentCredential).getPasswords();
        PasswordToken pToken = PasswordToken.loadFromJson(rawCredential);
        if (verify) {
            this.verifyNewPassword(pToken.getPassword(), currentPasswords, this.credential.getHistorySize());
        }
        return this.prepareCredentialForStorage(currentPasswords, pToken);
    }

    private String prepareCredentialForStorage(Deque<PasswordInfo> currentPasswords, PasswordToken pToken) throws IllegalCredentialException, InternalException {
        if (this.credential.getPasswordResetSettings().isEnabled() && this.credential.getPasswordResetSettings().isRequireSecurityQuestion()) {
            if (pToken.getAnswer() == null || pToken.getQuestion() == -1) {
                throw new IllegalCredentialException("The credential must select a security question and provide an answer for it");
            }
            if (pToken.getQuestion() < 0 || pToken.getQuestion() >= this.credential.getPasswordResetSettings().getQuestions().size()) {
                throw new IllegalCredentialException("The chosen answer for security question is invalid");
            }
        }
        PasswordInfo currentPassword = this.passwordEngine.prepareForStore(this.credential, pToken.getPassword());
        if (this.credential.getHistorySize() <= currentPasswords.size() && !currentPasswords.isEmpty()) {
            currentPasswords.removeLast();
        }
        currentPasswords.addFirst(currentPassword);
        PasswordInfo questionAnswer = pToken.getAnswer() != null ? this.passwordEngine.prepareForStore(this.credential, pToken.getAnswer()) : null;
        return PasswordCredentialDBState.toJson(this.credential, currentPasswords, pToken.getQuestion(), questionAnswer);
    }

    public String invalidate(String currentCredential) {
        try {
            ObjectNode root = (ObjectNode)Constants.MAPPER.readTree(currentCredential);
            root.put("outdated", true);
            return Constants.MAPPER.writeValueAsString((Object)root);
        }
        catch (Exception e) {
            throw new InternalException("Can't deserialize password credential from JSON", (Throwable)e);
        }
    }

    public CredentialPublicInformation checkCredentialState(String currentCredential) throws InternalException {
        PasswordCredentialDBState parsedCred = PasswordCredentialDBState.fromJson(currentCredential);
        Deque<PasswordInfo> currentPasswords = parsedCred.getPasswords();
        if (currentPasswords.isEmpty()) {
            return new CredentialPublicInformation(LocalCredentialState.notSet, "");
        }
        PasswordInfo currentPassword = currentPasswords.getFirst();
        PasswordExtraInfo pei = new PasswordExtraInfo(currentPassword.getTime(), parsedCred.getSecurityQuestion());
        String extraInfo = pei.toJson();
        PasswordStatus upToDateStatus = this.checkIfCredentialIsOutdated(parsedCred);
        if (upToDateStatus.outdated) {
            return new CredentialPublicInformation(LocalCredentialState.outdated, upToDateStatus.reason, extraInfo);
        }
        if (this.storedPasswordRequiresRehash(parsedCred)) {
            return new CredentialPublicInformation(LocalCredentialState.outdated, "rehash required", extraInfo);
        }
        return new CredentialPublicInformation(LocalCredentialState.correct, extraInfo);
    }

    public Optional<String> updateCredentialAfterConfigurationChange(String currentCredential) {
        PasswordCredentialDBState parsedCred = PasswordCredentialDBState.fromJson(currentCredential);
        Deque<PasswordInfo> passwords = parsedCred.getPasswords();
        boolean changed = this.removeHistoricalPasswordsStoredWithOutdatedMechanism(passwords);
        if (changed |= this.removeExcessHistoricalPasswords(passwords, this.credential.getHistorySize())) {
            String updatedCredential = JsonUtil.toJsonString((Object)parsedCred);
            return Optional.of(updatedCredential);
        }
        return Optional.empty();
    }

    private boolean removeHistoricalPasswordsStoredWithOutdatedMechanism(Deque<PasswordInfo> passwords) {
        boolean changed = false;
        Iterator<PasswordInfo> iterator = passwords.iterator();
        iterator.next();
        while (iterator.hasNext()) {
            PasswordInfo passwordInfo = iterator.next();
            if (this.passwordEngine.checkParamsUpToDate(this.credential, passwordInfo)) continue;
            iterator.remove();
            changed = true;
        }
        return changed;
    }

    private boolean removeExcessHistoricalPasswords(Deque<PasswordInfo> passwords, int historySize) {
        boolean changed = false;
        while (historySize == 0 && passwords.size() > 1 || historySize > 0 && passwords.size() > historySize) {
            passwords.removeLast();
            changed = true;
        }
        return changed;
    }

    @Override
    public AuthenticationResult checkPassword(String username, String password, SandboxAuthnResultCallback sandboxCallback) {
        AuthenticationResult authenticationResult = this.checkPasswordInternal(username, password);
        if (sandboxCallback != null) {
            sandboxCallback.sandboxedAuthenticationDone((SandboxAuthnContext)new LocalSandboxAuthnContext(authenticationResult));
        }
        return authenticationResult;
    }

    private AuthenticationResult checkPasswordInternal(String username, String password) {
        EntityWithCredential resolved;
        try {
            resolved = this.identityResolver.resolveIdentity(username, IDENTITY_TYPES, this.credentialName);
        }
        catch (Exception e) {
            log.debug("The user for password authN can not be found: " + username, (Throwable)e);
            return new AuthenticationResult(AuthenticationResult.Status.deny, null);
        }
        try {
            String dbCredential = resolved.getCredentialValue();
            PasswordCredentialDBState credState = PasswordCredentialDBState.fromJson(dbCredential);
            Deque<PasswordInfo> credentials = credState.getPasswords();
            if (credentials.isEmpty()) {
                log.debug("The user has no password set: {}", (Object)username);
                return new AuthenticationResult(AuthenticationResult.Status.deny, null);
            }
            PasswordInfo current = credentials.getFirst();
            if (!this.passwordEngine.verify(current, password)) {
                log.debug("Password provided by {} is invalid", (Object)username);
                return new AuthenticationResult(AuthenticationResult.Status.deny, null);
            }
            boolean isOutdated = this.isCurrentPasswordOutdated(password, credState, resolved);
            AuthenticatedEntity ae = new AuthenticatedEntity(Long.valueOf(resolved.getEntityId()), username, isOutdated ? resolved.getCredentialName() : null);
            return new AuthenticationResult(AuthenticationResult.Status.success, ae);
        }
        catch (Exception e) {
            log.debug("Error during password verification for " + username, (Throwable)e);
            return new AuthenticationResult(AuthenticationResult.Status.deny, null);
        }
    }

    @Override
    public CredentialReset getCredentialResetBackend() {
        return new PasswordCredentialResetImpl(this.notificationProducer, this.identityResolver, (LocalCredentialVerificator)this, this.credentialHelper, this.credentialName, this.credential.getSerializedConfiguration(), this.credential.getPasswordResetSettings(), this.passwordEngine);
    }

    private boolean isCurrentPasswordOutdated(String password, PasswordCredentialDBState credState, EntityWithCredential resolved) throws AuthenticationException {
        if (this.isCurrentCredentialOutdated(credState)) {
            return true;
        }
        try {
            this.verifyPasswordStrength(password);
        }
        catch (IllegalCredentialException e) {
            log.info("User with id {} logged in with password not matching current credential requirements, invalidating the password", (Object)resolved.getEntityId());
            String invalidated = this.invalidate(resolved.getCredentialValue());
            try {
                this.credentialHelper.updateCredential(resolved.getEntityId(), resolved.getCredentialName(), invalidated);
            }
            catch (EngineException ee) {
                throw new AuthenticationException("Problem invalidating outdated credential", (Exception)((Object)ee));
            }
            return true;
        }
        if (this.storedPasswordRequiresRehash(credState)) {
            log.debug("Password hash of user {} is outdated: hashing parameters were changed", (Object)resolved.getEntityId());
            this.rehashPassword(password, credState, resolved);
        }
        return false;
    }

    private void rehashPassword(String password, PasswordCredentialDBState credState, EntityWithCredential resolved) throws AuthenticationException {
        try {
            log.info("Re-hashing password of entity {} to match updated security requirements", (Object)resolved.getEntityId());
            PasswordToken passwordToken = new PasswordToken(password);
            String rehashed = this.prepareCredentialForStorage(credState.getPasswords(), passwordToken);
            this.credentialHelper.updateCredential(resolved.getEntityId(), resolved.getCredentialName(), rehashed);
        }
        catch (Exception e) {
            throw new AuthenticationException("Problem rehasing password", e);
        }
    }

    private boolean isCurrentCredentialOutdated(PasswordCredentialDBState credState) {
        return this.checkIfCredentialIsOutdated((PasswordCredentialDBState)credState).outdated;
    }

    private PasswordStatus checkIfCredentialIsOutdated(PasswordCredentialDBState credState) {
        if (credState.isOutdated()) {
            return new PasswordStatus(true, "set as");
        }
        if (credState.getSecurityQuestion() == null && this.credential.getPasswordResetSettings().isEnabled() && this.credential.getPasswordResetSettings().isRequireSecurityQuestion()) {
            return new PasswordStatus(true, "no question");
        }
        PasswordInfo current = credState.getPasswords().getFirst();
        Date validityEnd = new Date(current.getTime().getTime() + this.credential.getMaxAge());
        if (new Date().after(validityEnd)) {
            return new PasswordStatus(true, "expired");
        }
        if (this.credential.getPasswordResetSettings().isEnabled() && this.credential.getPasswordResetSettings().isRequireSecurityQuestion() && !this.passwordEngine.checkParamsUpToDate(this.credential, credState.getAnswer())) {
            return new PasswordStatus(true, "question outdated");
        }
        return new PasswordStatus(false, null);
    }

    private boolean storedPasswordRequiresRehash(PasswordCredentialDBState credState) {
        PasswordInfo password = credState.getPasswords().getFirst();
        return !this.passwordEngine.checkParamsUpToDate(this.credential, password);
    }

    private void verifyNewPassword(String password, Deque<PasswordInfo> currentCredentials, int historyLookback) throws IllegalCredentialException {
        this.verifyPasswordStrength(password);
        this.verifyPasswordNotReused(password, currentCredentials, historyLookback);
    }

    private void verifyPasswordStrength(String password) throws IllegalCredentialException {
        Zxcvbn zxcvbn = new Zxcvbn();
        Strength strength = zxcvbn.measure((CharSequence)password);
        if (strength.getGuessesLog10() < (double)this.credential.getMinScore()) {
            throw new IllegalCredentialException("Password has too low score " + strength.getGuessesLog10() + "/" + this.credential.getMinScore());
        }
        PasswordValidator validator = this.getPasswordValidator();
        RuleResult result = validator.validate(new PasswordData(new Password(password)));
        if (!result.isValid()) {
            throw new IllegalCredentialException("Password is too weak");
        }
    }

    private void verifyPasswordNotReused(String password, Deque<PasswordInfo> currentCredentials, int historyLookback) throws IllegalCredentialException {
        Iterator<PasswordInfo> iterator = currentCredentials.iterator();
        for (int i = 0; i < historyLookback && iterator.hasNext(); ++i) {
            PasswordInfo pi = iterator.next();
            if (!this.passwordEngine.verify(pi, password)) continue;
            throw new CredentialRecentlyUsedException("The same password was recently used");
        }
    }

    private PasswordValidator getPasswordValidator() {
        ArrayList<Object> ruleList = new ArrayList<Object>();
        ruleList.add(new LengthRule(this.credential.getMinLength(), 512));
        CharacterCharacteristicsRule charRule = new CharacterCharacteristicsRule();
        charRule.setRules(PasswordVerificator.getCharacteristicsRules());
        charRule.setNumberOfCharacteristics(this.credential.getMinClassesNum());
        ruleList.add(charRule);
        if (this.credential.isDenySequences()) {
            ruleList.addAll(PasswordVerificator.getSequencesRules());
        }
        return new PasswordValidator(ruleList);
    }

    public boolean isCredentialDefinitionChagneOutdatingCredentials(String newCredentialDefinition) {
        PasswordCredential updated = new PasswordCredential();
        updated.setSerializedConfiguration(JsonUtil.parse((String)newCredentialDefinition));
        return updated.hasStrongerRequirementsThen(this.credential);
    }

    public static List<CharacterRule> getCharacteristicsRules() {
        return Lists.newArrayList((Object[])new CharacterRule[]{new DigitCharacterRule(1), new NonAlphanumericCharacterRule(1), new UppercaseCharacterRule(1), new LowercaseCharacterRule(1)});
    }

    public static List<Rule> getSequencesRules() {
        return Lists.newArrayList((Object[])new Rule[]{new AlphabeticalSequenceRule(), new NumericalSequenceRule(3, true), new QwertySequenceRule(), new RepeatCharacterRegexRule(4)});
    }

    public boolean isCredentialSet(EntityParam entity) throws EngineException {
        return this.credentialHelper.isCredentialSet(entity, this.credentialName);
    }

    @Component
    public static class Factory
    extends AbstractLocalCredentialVerificatorFactory {
        @Autowired
        public Factory(ObjectFactory<PasswordVerificator> factory) {
            super(PasswordVerificator.NAME, PasswordVerificator.DESC, true, factory);
        }
    }

    private static class PasswordStatus {
        boolean outdated;
        String reason;

        PasswordStatus(boolean outdated, String reason) {
            this.outdated = outdated;
            this.reason = reason;
        }
    }
}

