/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.stdext.utils;

import com.google.common.collect.Lists;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.stream.Collectors;
import pl.edu.icm.unity.attr.ImageType;
import pl.edu.icm.unity.attr.UnityImage;
import pl.edu.icm.unity.stdext.attr.JpegImageAttributeSyntax;
import pl.edu.icm.unity.types.basic.Attribute;

public final class JpegImageAttributeCreator {
    public static Attribute of(String name, String groupPath, List<String> values, String remoteIdp, String translationProfile) {
        return new Attribute(name, "jpegImage", groupPath, values, remoteIdp, translationProfile);
    }

    public static Attribute of(String name, String groupPath, List<BufferedImage> values) {
        return new Attribute(name, "jpegImage", groupPath, JpegImageAttributeCreator.convert(values));
    }

    public static Attribute of(String name, String groupPath, BufferedImage ... values) {
        return JpegImageAttributeCreator.of(name, groupPath, Lists.newArrayList((Object[])values));
    }

    private static List<String> convert(List<BufferedImage> values) {
        JpegImageAttributeSyntax syntax = new JpegImageAttributeSyntax();
        return values.stream().map(bufferedImage -> new UnityImage(bufferedImage, ImageType.JPG)).map(v -> syntax.convertToString((UnityImage)v)).collect(Collectors.toList());
    }
}

