/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.stdext.attr;

import java.io.IOException;
import org.springframework.stereotype.Component;
import pl.edu.icm.unity.attr.UnityImage;
import pl.edu.icm.unity.engine.api.attributes.AbstractAttributeValueSyntaxFactory;
import pl.edu.icm.unity.exceptions.IllegalAttributeValueException;
import pl.edu.icm.unity.exceptions.InternalException;
import pl.edu.icm.unity.stdext.attr.BaseImageAttributeSyntax;
import pl.edu.icm.unity.stdext.utils.ImageValidatorUtil;

public class ImageAttributeSyntax
extends BaseImageAttributeSyntax<UnityImage> {
    public static final String ID = "image";

    public String getValueSyntaxId() {
        return ID;
    }

    public void validate(UnityImage value) throws IllegalAttributeValueException {
        ImageValidatorUtil.validate(this.getConfig(), value);
    }

    public UnityImage convertFromString(String stringRepresentation) {
        try {
            return new UnityImage(stringRepresentation);
        }
        catch (IOException e) {
            throw new InternalException("Error encoding image from string.", (Throwable)e);
        }
    }

    public String convertToString(UnityImage value) {
        return value.serialize();
    }

    @Component
    public static class Factory
    extends AbstractAttributeValueSyntaxFactory<UnityImage> {
        public Factory() {
            super(ImageAttributeSyntax.ID, ImageAttributeSyntax::new);
        }
    }
}

