/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.stdext.attr;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import pl.edu.icm.unity.stdext.attr.IntegerAttributeSyntax;
import pl.edu.icm.unity.types.basic.Attribute;

public class IntegerAttribute {
    public static Attribute of(String name, String groupPath, List<String> values, String remoteIdp, String translationProfile) {
        return new Attribute(name, "integer", groupPath, values, remoteIdp, translationProfile);
    }

    public static Attribute of(String name, String groupPath, List<? extends Number> values) {
        return new Attribute(name, "integer", groupPath, IntegerAttribute.convert(values));
    }

    public static Attribute of(String name, String groupPath, Long ... values) {
        return IntegerAttribute.of(name, groupPath, Lists.newArrayList((Object[])values));
    }

    public static Attribute of(String name, String groupPath, Integer ... values) {
        return IntegerAttribute.of(name, groupPath, Lists.newArrayList((Object[])values));
    }

    private static List<String> convert(List<? extends Number> values) {
        IntegerAttributeSyntax syntax = new IntegerAttributeSyntax();
        return values.stream().map(v -> syntax.convertToString(v.longValue())).collect(Collectors.toList());
    }
}

