/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.stdext.attr;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.springframework.stereotype.Component;
import pl.edu.icm.unity.Constants;
import pl.edu.icm.unity.engine.api.attributes.AbstractAttributeValueSyntaxFactory;
import pl.edu.icm.unity.engine.api.attributes.AttributeValueSyntax;
import pl.edu.icm.unity.exceptions.IllegalAttributeValueException;
import pl.edu.icm.unity.exceptions.WrongArgumentException;

public class IntegerAttributeSyntax
implements AttributeValueSyntax<Long> {
    public static final String ID = "integer";
    private long min = Long.MIN_VALUE;
    private long max = Long.MAX_VALUE;

    public ObjectNode getSerializedConfiguration() {
        ObjectNode main = Constants.MAPPER.createObjectNode();
        main.put("min", this.getMin());
        main.put("max", this.getMax());
        return main;
    }

    public void setSerializedConfiguration(JsonNode jsonN) {
        this.min = jsonN.get("min").asLong();
        this.max = jsonN.get("max").asLong();
    }

    public String getValueSyntaxId() {
        return ID;
    }

    public void validate(Long value) throws IllegalAttributeValueException {
        if (value == null) {
            throw new IllegalAttributeValueException("null value is illegal");
        }
        if (value < this.min) {
            throw new IllegalAttributeValueException("Value (" + value + ") is too small, must be at least " + this.min);
        }
        if (value > this.max) {
            throw new IllegalAttributeValueException("Value (" + value + ") is too big, must be not greater than " + this.max);
        }
    }

    public boolean areEqual(Long value, Object another) {
        return value == null ? null == another : value.equals(another);
    }

    public int hashCode(Object value) {
        return value.hashCode();
    }

    public long getMin() {
        return this.min;
    }

    public void setMin(long min) throws WrongArgumentException {
        if (min > this.max) {
            throw new WrongArgumentException("Minimum must not be less then the maximum");
        }
        this.min = min;
    }

    public long getMax() {
        return this.max;
    }

    public void setMax(long max) throws WrongArgumentException {
        if (max < this.min) {
            throw new WrongArgumentException("Maximum must not be less then the minimum");
        }
        this.max = max;
    }

    public boolean isEmailVerifiable() {
        return false;
    }

    public boolean isUserVerifiable() {
        return false;
    }

    public Long convertFromString(String stringRepresentation) {
        return Long.parseLong(stringRepresentation);
    }

    public String convertToString(Long value) {
        return value.toString();
    }

    @Component
    public static class Factory
    extends AbstractAttributeValueSyntaxFactory<Long> {
        public Factory() {
            super(IntegerAttributeSyntax.ID, IntegerAttributeSyntax::new);
        }
    }
}

