/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.stdext.credential;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import java.util.Locale;
import org.apache.logging.log4j.Logger;
import pl.edu.icm.unity.JsonUtil;
import pl.edu.icm.unity.base.utils.Log;
import pl.edu.icm.unity.engine.api.authn.AuthenticationSubject;
import pl.edu.icm.unity.engine.api.authn.CredentialReset;
import pl.edu.icm.unity.engine.api.authn.EntityWithCredential;
import pl.edu.icm.unity.engine.api.authn.local.CredentialHelper;
import pl.edu.icm.unity.engine.api.authn.local.LocalCredentialVerificator;
import pl.edu.icm.unity.engine.api.identity.IdentityResolver;
import pl.edu.icm.unity.engine.api.msg.LocaleHelper;
import pl.edu.icm.unity.engine.api.notification.NotificationProducer;
import pl.edu.icm.unity.engine.api.utils.CodeGenerator;
import pl.edu.icm.unity.exceptions.EngineException;
import pl.edu.icm.unity.exceptions.IllegalIdentityValueException;
import pl.edu.icm.unity.exceptions.TooManyAttempts;
import pl.edu.icm.unity.exceptions.WrongArgumentException;
import pl.edu.icm.unity.types.basic.EntityParam;

public abstract class CredentialResetBase
implements CredentialReset {
    private static final Logger log = Log.getLogger((String)"unity.server", CredentialResetBase.class);
    protected static final int MAX_ANSWER_ATTEMPTS = 2;
    private static final int MAX_RESENDS = 3;
    private static final long MAX_CODE_VALIDITY = 108000L;
    private NotificationProducer notificationProducer;
    private IdentityResolver identityResolver;
    private CredentialHelper credentialHelper;
    private LocalCredentialVerificator localCredentialHandler;
    protected EntityWithCredential resolved;
    private String credentialId;
    private ObjectNode completeCredentialConfiguration;
    private String codeSent;
    private long codeValidityEnd;
    private int dynamicAnswerAttempts = 0;
    private int codeSendingAttempts = 0;
    private AuthenticationSubject requestedSubject;

    public CredentialResetBase(NotificationProducer notificationProducer, IdentityResolver identityResolver, LocalCredentialVerificator localVerificator, CredentialHelper credentialHelper, String credentialId, ObjectNode completeCredentialConfiguration) {
        this.notificationProducer = notificationProducer;
        this.credentialHelper = credentialHelper;
        this.identityResolver = identityResolver;
        this.credentialId = credentialId;
        this.localCredentialHandler = localVerificator;
        this.completeCredentialConfiguration = completeCredentialConfiguration;
    }

    public void setSubject(AuthenticationSubject subject, String[] idTypes) {
        this.requestedSubject = subject;
        try {
            this.resolved = this.identityResolver.resolveSubject(subject, idTypes, this.credentialId);
        }
        catch (IllegalIdentityValueException illegalIdentityValueException) {
        }
        catch (Exception e) {
            log.error("Exception when trying to resolve identity", (Throwable)e);
        }
    }

    protected boolean checkSubject() {
        return this.resolved != null && this.resolved.getCredentialValue() != null;
    }

    public Long getEntityId() {
        return this.resolved.getEntityId();
    }

    public String getSettings() {
        return this.getCredentialSettings();
    }

    protected abstract String getCredentialSettings();

    protected AuthenticationSubject getRequestedSubject() {
        return this.requestedSubject;
    }

    public String getSecurityQuestion() {
        return null;
    }

    public void verifyStaticData(String answer) throws WrongArgumentException, IllegalIdentityValueException, TooManyAttempts {
    }

    private void createCode(boolean onlyNumberCode) {
        int codeLen = this.getCodeLength();
        this.codeSent = !onlyNumberCode ? CodeGenerator.generateMixedCharCode((int)codeLen) : CodeGenerator.generateNumberCode((int)codeLen);
        this.codeValidityEnd = System.currentTimeMillis() + 108000L;
    }

    protected abstract int getCodeLength();

    public void sendCode(String msgTemplate, boolean onlyNumberCode) throws EngineException {
        if (!this.checkSubject()) {
            throw new IllegalIdentityValueException("Identity was not resolved or has no credential set");
        }
        if (this.codeSendingAttempts >= 3) {
            throw new TooManyAttempts();
        }
        ++this.codeSendingAttempts;
        if (this.codeSent == null) {
            this.createCode(onlyNumberCode);
        }
        String username = this.identityResolver.getDisplayedUserName(new EntityParam(Long.valueOf(this.resolved.getEntityId())));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("code", this.codeSent);
        params.put("user", username);
        Locale currentLocale = LocaleHelper.getLocale(null);
        String locale = currentLocale == null ? null : currentLocale.toString();
        this.notificationProducer.sendNotification(new EntityParam(Long.valueOf(this.resolved.getEntityId())), msgTemplate, params, locale, username, true);
    }

    public void verifyDynamicData(String answer) throws WrongArgumentException, TooManyAttempts {
        if (this.dynamicAnswerAttempts >= 2) {
            throw new TooManyAttempts();
        }
        ++this.dynamicAnswerAttempts;
        if (System.currentTimeMillis() > this.codeValidityEnd) {
            throw new TooManyAttempts();
        }
        if (this.codeSent == null || !this.codeSent.equals(answer)) {
            throw new WrongArgumentException("The code is invalid");
        }
        this.dynamicAnswerAttempts = 0;
        this.codeSendingAttempts = 0;
        this.codeSent = null;
    }

    public String getCredentialConfiguration() {
        return JsonUtil.toJsonString((Object)this.completeCredentialConfiguration);
    }

    public void updateCredential(String newCredential) throws EngineException {
        if (!this.checkSubject()) {
            throw new IllegalStateException("Identity was not resolved.");
        }
        this.credentialHelper.setCredential(this.resolved.getEntityId(), this.credentialId, newCredential, this.localCredentialHandler);
    }
}

