/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.stdext.credential.pass;

import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import org.bouncycastle.crypto.generators.SCrypt;
import pl.edu.icm.unity.stdext.credential.pass.ScryptParams;

public class SCryptEncoder {
    private ForkJoinPool pool;
    private long maxMemory;

    public SCryptEncoder(ForkJoinPool pool) {
        this(pool, Runtime.getRuntime().maxMemory());
    }

    SCryptEncoder(ForkJoinPool pool, long maxHeap) {
        this.pool = pool;
        this.maxMemory = maxHeap;
    }

    public int getMaxAllowedWorkFactor() {
        long reservedMemory;
        long availableMemory;
        int parallelizm = this.pool.getParallelism();
        if (this.maxMemory == Long.MAX_VALUE) {
            this.maxMemory = 0x40000000L;
        }
        if ((availableMemory = this.maxMemory - (reservedMemory = 500000000L)) <= 0L) {
            return 6;
        }
        long availablePerThread = availableMemory / (long)parallelizm;
        long maxCost = availablePerThread / 1024L;
        int maxWorkFactor = -1;
        while (maxCost != 0L) {
            maxCost >>= 1;
            ++maxWorkFactor;
        }
        if (maxWorkFactor < 6) {
            return 6;
        }
        if (maxWorkFactor > 23) {
            return 23;
        }
        return maxWorkFactor;
    }

    public byte[] scrypt(String password, byte[] salt, ScryptParams params) {
        Future task = this.pool.submit(() -> this.runScrypt(password, salt, params));
        try {
            return (byte[])((ForkJoinTask)task).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Interrupted when scrypting", e);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("Error when scrypting", e);
        }
    }

    private byte[] runScrypt(String password, byte[] salt, ScryptParams params) {
        return SCrypt.generate((byte[])password.getBytes(StandardCharsets.UTF_8), (byte[])salt, (int)(1 << params.getWorkFactor()), (int)params.getBlockSize(), (int)params.getParallelization(), (int)params.getLength());
    }
}

