/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.stdext.credential.pass;

import java.util.HashMap;
import java.util.Map;

public class ScryptParams {
    public static final int MIN_WORK_FACTOR = 6;
    public static final int MAX_WORK_FACTOR = 23;
    private int workFactor;
    private int blockSize;
    private int parallelization;
    private int length;

    public ScryptParams(Map<String, Object> params) {
        this((Integer)params.get("workFactor"), (Integer)params.get("blockSize"), (Integer)params.get("parallelization"), (Integer)params.get("length"));
    }

    public ScryptParams(int workFactor, int blockSize, int parallelization, int length) {
        this.workFactor = workFactor;
        this.blockSize = blockSize;
        this.parallelization = parallelization;
        this.length = length;
        this.sanitize();
    }

    public ScryptParams() {
        this(15);
    }

    public ScryptParams(int workFactor) {
        this(workFactor, 8, 1, 64);
    }

    public void sanitize() {
        if (this.workFactor < 6) {
            this.workFactor = 6;
        }
        if (this.workFactor > 23) {
            this.workFactor = 23;
        }
        if (this.blockSize < 8) {
            this.blockSize = 8;
        }
        if (this.blockSize > 16384) {
            this.blockSize = 16384;
        }
        if (this.parallelization < 1) {
            this.parallelization = 1;
        }
        if (this.parallelization > 64) {
            this.parallelization = 64;
        }
        if (this.length < 32) {
            this.length = 32;
        }
        if (this.length > 2048) {
            this.length = 2048;
        }
    }

    public int getWorkFactor() {
        return this.workFactor;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public int getParallelization() {
        return this.parallelization;
    }

    public int getLength() {
        return this.length;
    }

    public boolean hasStrongerRequirementsThen(ScryptParams other) {
        if (this.workFactor > other.workFactor) {
            return true;
        }
        if (this.length > other.length) {
            return true;
        }
        if (this.parallelization > other.parallelization) {
            return true;
        }
        return this.blockSize != other.blockSize;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.blockSize;
        result = 31 * result + this.length;
        result = 31 * result + this.parallelization;
        result = 31 * result + this.workFactor;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ScryptParams other = (ScryptParams)obj;
        if (this.blockSize != other.blockSize) {
            return false;
        }
        if (this.length != other.length) {
            return false;
        }
        if (this.parallelization != other.parallelization) {
            return false;
        }
        return this.workFactor == other.workFactor;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("workFactor", this.workFactor);
        params.put("blockSize", this.blockSize);
        params.put("parallelization", this.parallelization);
        params.put("length", this.length);
        return params;
    }
}

