/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.stdext.credential.pass;

import com.nulabinc.zxcvbn.Feedback;
import com.nulabinc.zxcvbn.Strength;
import com.nulabinc.zxcvbn.Zxcvbn;
import edu.vt.middleware.password.CharacterRule;
import edu.vt.middleware.password.Password;
import edu.vt.middleware.password.PasswordData;
import edu.vt.middleware.password.Rule;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.springframework.context.support.MessageSourceResourceBundle;
import pl.edu.icm.unity.MessageSource;
import pl.edu.icm.unity.stdext.credential.pass.PasswordVerificator;

public class StrengthChecker {
    private static final int DEFAULT_PERFECT_SCORE = 14;

    public static StrengthInfo measure(String password, int minAcceptable, MessageSource msg) {
        return StrengthChecker.measure(password, minAcceptable, msg.getLocale(), msg);
    }

    static StrengthInfo measure(String password, int minAcceptable, Locale locale, MessageSource msg) {
        Zxcvbn zxcvbn = new Zxcvbn();
        Strength strength = zxcvbn.measure((CharSequence)password);
        MessageSourceResourceBundle msgAdapter = new MessageSourceResourceBundle((org.springframework.context.MessageSource)msg, locale);
        Feedback feedback = strength.getFeedback();
        Feedback localizedFeedback = feedback.withResourceBundle((ResourceBundle)msgAdapter);
        return new StrengthInfo(StrengthChecker.normalizeScore(strength, minAcceptable), (int)strength.getGuessesLog10(), localizedFeedback.getWarning(locale), localizedFeedback.getSuggestions(locale));
    }

    public static int getCharacterClasses(String password) {
        List<CharacterRule> charClassesRules = PasswordVerificator.getCharacteristicsRules();
        PasswordData passwordData = new PasswordData(new Password(password));
        int ret = 0;
        for (CharacterRule rule : charClassesRules) {
            if (!rule.validate(passwordData).isValid()) continue;
            ++ret;
        }
        return ret;
    }

    public static boolean hasNoTrivialSequences(String password) {
        List<Rule> charClassesRules = PasswordVerificator.getSequencesRules();
        PasswordData passwordData = new PasswordData(new Password(password));
        for (Rule rule : charClassesRules) {
            if (rule.validate(passwordData).isValid()) continue;
            return false;
        }
        return true;
    }

    private static double normalizeScore(Strength strength, int minAllowed) {
        int perfectScore = 14 > minAllowed ? 14 : minAllowed;
        double guessesLog10 = strength.getGuessesLog10();
        double scoreBounded = guessesLog10 > (double)perfectScore ? (double)perfectScore : guessesLog10;
        return scoreBounded / (double)perfectScore;
    }

    public static class StrengthInfo {
        public final double scoreNormalized;
        public final int score;
        public final String warning;
        public final List<String> suggestions;

        public StrengthInfo(double scoreNormalized, int score, String warning, List<String> suggestions) {
            this.scoreNormalized = scoreNormalized;
            this.score = score;
            this.warning = warning;
            this.suggestions = Collections.unmodifiableList(suggestions);
        }

        public String toString() {
            return "StrengthInfo [score=" + this.scoreNormalized + ", warning=" + this.warning + ", suggestions=" + this.suggestions + "]";
        }
    }
}

