/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.stdext.credential.sms;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Optional;
import pl.edu.icm.unity.Constants;
import pl.edu.icm.unity.exceptions.InternalException;
import pl.edu.icm.unity.stdext.credential.sms.SMSCredentialRecoverySettings;
import pl.edu.icm.unity.types.confirmation.MobileNumberConfirmationConfiguration;

public class SMSCredential {
    public static final int DEFAULT_VALIDITY = 15;
    public static final int DEFAULT_CODE_LENGTH = 6;
    private static final int AUTHN_SMS_LIMIT = 3;
    private int validityTime = 15;
    private int codeLength = 6;
    private String messageTemplate;
    private int authnSMSLimit = 3;
    private MobileNumberConfirmationConfiguration mobileNumberConfirmationConfiguration;
    private SMSCredentialRecoverySettings recoverySettings = new SMSCredentialRecoverySettings();

    public ObjectNode getSerializedConfiguration() throws InternalException {
        ObjectNode root = Constants.MAPPER.createObjectNode();
        root.put("validityTime", this.validityTime);
        root.put("codeLength", this.codeLength);
        root.put("messageTemplate", this.messageTemplate);
        root.put("authnSMSLimit", this.authnSMSLimit);
        ObjectNode recoverNode = root.putObject("recoverySettings");
        this.recoverySettings.serializeTo(recoverNode);
        if (this.getMobileNumberConfirmationConfiguration().isPresent()) {
            root.set("mobileConfirmationConfiguration", (JsonNode)this.getMobileNumberConfirmationConfiguration().get().toJson());
        }
        return root;
    }

    public void setSerializedConfiguration(ObjectNode root) throws InternalException {
        JsonNode recoverNode;
        this.codeLength = root.get("codeLength").asInt();
        if (this.codeLength <= 2 || this.codeLength > 50) {
            throw new InternalException("Minimal code length must be in range [1-50]");
        }
        this.validityTime = root.get("validityTime").asInt();
        if (this.validityTime < 0 || this.validityTime > 525600) {
            throw new InternalException("Validity time must be in range [0-525600]");
        }
        this.setAuthnSMSLimit(root.get("authnSMSLimit").asInt());
        if (this.getAuthnSMSLimit() < 0 || this.getAuthnSMSLimit() > 10000) {
            throw new InternalException("AuthnSMSLimit must be in range [0-10000]");
        }
        JsonNode msg = root.get("messageTemplate");
        if (msg != null) {
            // empty if block
        }
        this.messageTemplate = msg.asText();
        JsonNode confirmationConfigNode = root.get("mobileConfirmationConfiguration");
        if (confirmationConfigNode != null) {
            this.setMobileNumberConfirmationConfiguration(new MobileNumberConfirmationConfiguration((ObjectNode)root.get("mobileConfirmationConfiguration")));
        }
        if ((recoverNode = root.get("recoverySettings")) != null) {
            this.recoverySettings.deserializeFrom((ObjectNode)recoverNode);
        }
    }

    public int getValidityTime() {
        return this.validityTime;
    }

    public void setValidityTime(int validityTime) {
        this.validityTime = validityTime;
    }

    public int getCodeLength() {
        return this.codeLength;
    }

    public void setCodeLength(int codeLength) {
        this.codeLength = codeLength;
    }

    public SMSCredentialRecoverySettings getRecoverySettings() {
        return this.recoverySettings;
    }

    public void setRecoverySettings(SMSCredentialRecoverySettings recoverSettings) {
        this.recoverySettings = recoverSettings;
    }

    public void setMobileNumberConfirmationConfiguration(MobileNumberConfirmationConfiguration confirmationConfiguration) {
        this.mobileNumberConfirmationConfiguration = confirmationConfiguration;
    }

    public Optional<MobileNumberConfirmationConfiguration> getMobileNumberConfirmationConfiguration() {
        return Optional.ofNullable(this.mobileNumberConfirmationConfiguration);
    }

    public String getMessageTemplate() {
        return this.messageTemplate;
    }

    public void setMessageTemplate(String messageTemplate) {
        this.messageTemplate = messageTemplate;
    }

    public int getAuthnSMSLimit() {
        return this.authnSMSLimit;
    }

    public void setAuthnSMSLimit(int authnSMSLimit) {
        this.authnSMSLimit = authnSMSLimit;
    }
}

