/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.stdext.identity;

import org.springframework.stereotype.Component;
import pl.edu.icm.unity.MessageSource;
import pl.edu.icm.unity.exceptions.IllegalIdentityValueException;
import pl.edu.icm.unity.stdext.identity.AbstractStaticIdentityTypeProvider;
import pl.edu.icm.unity.stdext.utils.EmailUtils;
import pl.edu.icm.unity.types.basic.IdentityParam;
import pl.edu.icm.unity.types.basic.VerifiableEmail;

@Component
public class EmailIdentity
extends AbstractStaticIdentityTypeProvider {
    public static final String ID = "email";

    public String getId() {
        return ID;
    }

    public String getDefaultDescriptionKey() {
        return "EmailIdentity.description";
    }

    public void validate(String value) throws IllegalIdentityValueException {
        String error = EmailUtils.validate(value);
        if (error != null) {
            throw new IllegalIdentityValueException(value + ": " + error);
        }
    }

    @Override
    public IdentityParam convertFromString(String stringRepresentation, String remoteIdp, String translationProfile) throws IllegalIdentityValueException {
        VerifiableEmail converted = EmailUtils.convertFromString(stringRepresentation);
        this.validate(converted.getValue());
        return EmailIdentity.toIdentityParam(converted, remoteIdp, translationProfile);
    }

    public static IdentityParam toIdentityParam(VerifiableEmail email, String remoteIdp, String translationProfile) {
        IdentityParam ret = new IdentityParam(ID, email.getValue(), remoteIdp, translationProfile);
        ret.setConfirmationInfo(email.getConfirmationInfo());
        return ret;
    }

    public static VerifiableEmail fromIdentityParam(IdentityParam idParam) {
        VerifiableEmail ret = new VerifiableEmail(idParam.getValue());
        if (idParam.getConfirmationInfo() != null) {
            ret.setConfirmationInfo(idParam.getConfirmationInfo());
        }
        return ret;
    }

    public String getComparableValue(String from, String realm, String target) {
        return new VerifiableEmail(from).getComparableValue();
    }

    public String toPrettyStringNoPrefix(IdentityParam from) {
        VerifiableEmail ve = EmailIdentity.fromIdentityParam(from);
        StringBuilder ret = new StringBuilder(ve.getValue());
        return ret.toString();
    }

    public String getHumanFriendlyDescription(MessageSource msg) {
        return msg.getMessage("EmailIdentity.description", new Object[0]);
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    public boolean isEmailVerifiable() {
        return true;
    }

    public String getHumanFriendlyName(MessageSource msg) {
        return msg.getMessage("EmailIdentity.name", new Object[0]);
    }
}

